/*
 * Decompiled with CFR 0.152.
 */
package rdt.BulletShadow;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import rdt.AgentSmith.AgentSmith;
import rdt.BulletShadow.BulletShadowData;
import rdt.BulletShadow.BulletShadowDataPool;
import rdt.BulletShadow.ShadowData;
import rdt.BulletShadow.ShadowDataPool;
import rdt.Waves.WaveData;
import rdt.Waves.WaveDataUtils;
import rdt.Waves.WaveGeneratedListener;
import rdt.Waves.WaveManager;
import rdt.Waves.WaveRemovedListener;

public class BulletShadowTracker
implements WaveGeneratedListener,
WaveRemovedListener {
    private WaveManager _ourWaveManager = null;
    private WaveManager _enemyWaveManager = null;
    private BulletShadowDataPool _pool = null;
    private ShadowDataPool _shadowPool = null;
    private List<BulletShadowData> _activeShadows = new ArrayList<BulletShadowData>();

    public BulletShadowTracker(WaveManager ourWaveManager, WaveManager enemyWaveManager) {
        this._ourWaveManager = ourWaveManager;
        this._enemyWaveManager = enemyWaveManager;
        this._ourWaveManager.AddGeneratedListener(this);
        this._pool = new BulletShadowDataPool(200);
        this._shadowPool = new ShadowDataPool(400);
    }

    public void OnRoundStart() {
        int index = 0;
        while (index < this._activeShadows.size()) {
            BulletShadowData bulletShadowData = this._activeShadows.get(index);
            this.ReleaseBulletShadowData(bulletShadowData);
            ++index;
        }
        this._activeShadows.clear();
    }

    private void ReleaseBulletShadowData(BulletShadowData data) {
        int index = 0;
        while (index < data.Shadows.size()) {
            this._shadowPool.ReturnToPool(data.Shadows.get(index));
            ++index;
        }
        data.Shadows.clear();
    }

    public void Update() {
    }

    public void DebugDraw(Graphics2D gfx) {
        this._ourWaveManager.DebugDraw(gfx);
        this._enemyWaveManager.DebugDraw(gfx);
        this.DrawActiveShadows(gfx);
    }

    @Override
    public void OnWaveRemoved(WaveData wave, double targetActualX, double targetActualY) {
        WaveManager cfr_ignored_0 = wave.OwningManager;
    }

    @Override
    public void OnWaveGenerated(WaveData wave) {
        if (wave.OwningManager == this._ourWaveManager && wave.WaveType != WaveData.eWaveType.Real) {
            return;
        }
    }

    private void OnNewGunWave(WaveData wave) {
        BulletShadowData data = this._pool.TakeFromPool();
        this._activeShadows.add(data);
        data.OurWave = wave;
        int numEnemyWaves = this._enemyWaveManager.GetNumActiveWaves();
        long currentTick = AgentSmith.Instance().getTime();
        int index = 0;
        while (index < numEnemyWaves) {
            WaveData enemyWave = this._enemyWaveManager.GetActiveWave(index);
            if (!this.PointInsideWave(enemyWave, wave.OriginX, wave.OriginY, currentTick)) {
                this.UpdateBulletShadowDataForNewEnemyWave(data, enemyWave);
            }
            ++index;
        }
    }

    private void UpdateBulletShadowDataForNewEnemyWave(BulletShadowData data, WaveData enemyWave) {
        int chosenGunIndex = data.OurWave.VirtualGunData.ChosenGunIndex;
        long tickToCheck = AgentSmith.Instance().getTime();
        double previousBulletX = data.OurWave.OriginX;
        double previousBulletY = data.OurWave.OriginY;
        while (true) {
            long ourSnapshotIndex;
            if ((ourSnapshotIndex = ++tickToCheck - data.OurWave.VirtualGunData.TickFired) >= (long)WaveData.WaveSnapshotCount) {
                System.out.println("No intercept found!");
                break;
            }
            WaveData.WaveAngleSnapshotData ourBulletPosition = data.OurWave.AngleSnapshots[chosenGunIndex][(int)ourSnapshotIndex];
            double x = ourBulletPosition.CurrentLocationX;
            double y = ourBulletPosition.CurrentLocationY;
            if (this.PointInsideWave(enemyWave, x, y, tickToCheck)) {
                ShadowData newShadowData = this._shadowPool.TakeFromPool();
                newShadowData.EnemyWave = enemyWave;
                newShadowData.InterceptTick = tickToCheck;
                newShadowData.InterceptX1 = previousBulletX;
                newShadowData.InterceptY1 = previousBulletY;
                newShadowData.InterceptX2 = x;
                newShadowData.InterceptY2 = y;
                data.Shadows.add(newShadowData);
                break;
            }
            previousBulletX = x;
            previousBulletY = y;
        }
    }

    private boolean PointInsideWave(WaveData wave, double x, double y, long tick) {
        long snapshotIndex = tick - wave.VirtualGunData.TickFired;
        if (snapshotIndex >= (long)WaveData.WaveSnapshotCount) {
            return true;
        }
        double deltaToWaveOriginX = x - wave.OriginX;
        double deltaToWaveOriginY = y - wave.OriginY;
        double distanceToOriginSq = deltaToWaveOriginX * deltaToWaveOriginX + deltaToWaveOriginY * deltaToWaveOriginY;
        double waveRadius = WaveDataUtils.GetWaveDistance(wave, tick);
        return distanceToOriginSq <= waveRadius * waveRadius;
    }

    private void DrawActiveShadows(Graphics2D gfx) {
        gfx.setColor(Color.orange);
        int index = 0;
        while (index < this._activeShadows.size()) {
            BulletShadowData bulletShadowData = this._activeShadows.get(index);
            this.DrawActiveShadow(bulletShadowData, gfx);
            ++index;
        }
    }

    private void DrawActiveShadow(BulletShadowData data, Graphics2D gfx) {
        int index = 0;
        while (index < data.Shadows.size()) {
            ShadowData shadowData = data.Shadows.get(index);
            this.DrawShadowData(shadowData, gfx);
            ++index;
        }
    }

    private void DrawShadowData(ShadowData data, Graphics2D gfx) {
        gfx.drawLine((int)data.InterceptX1, (int)data.InterceptY1, (int)data.InterceptX2, (int)data.InterceptY2);
    }
}

