/*
 * Decompiled with CFR 0.152.
 */
package bbo;

import java.awt.Color;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.MoveCompleteCondition;
import robocode.ScannedRobotEvent;
import robocode.TurnCompleteCondition;

public class TheRoof
extends AdvancedRobot {
    static double lastEnemyHeading;
    private boolean indMovement = true;
    private boolean indScanning = true;
    private boolean indFiring = true;
    private double dFieldHeight = 0.0;
    private double dFieldWidth = 0.0;
    private double dRobotMargeX = 0.0;
    private double dRobotMargeY = 0.0;
    private double dMaxEnemyDistance = 0.0;
    private double enemyAbsoluteBearing = 0.0;
    private double timeSinceLastScan = 10.0;
    private int state = 0;

    private int isAtWall() {
        double y = 0.0;
        int result = 0;
        double x = this.getX();
        y = this.getY();
        if (x <= this.dRobotMargeX) {
            result = 1;
        } else if (this.dFieldWidth - x <= this.dRobotMargeX) {
            result = 2;
        } else if (y <= this.dRobotMargeY) {
            result = 3;
        } else if (this.dFieldHeight - y <= this.dRobotMargeY) {
            result = 4;
        }
        return result;
    }

    private void GoToCorner() {
        double y = 0.0;
        boolean result = false;
        double heading = 0.0;
        double distance = 0.0;
        if (this.state == 10) {
            this.setMaxVelocity(8.0);
            this.setTurnLeft(90.0);
            this.setAhead(90.0);
            this.execute();
            this.state = 11;
        } else if (this.state == 11) {
            if (this.isAtWall() != 0) {
                this.state = 0;
            } else {
                this.setAhead(200.0);
                this.execute();
            }
        } else if (this.state != 1) {
            double x = this.getX();
            y = this.getY();
            heading = this.getHeading();
            distance = heading >= 305.0 || heading < 45.0 ? this.dFieldHeight - this.dRobotMargeY - y : (heading >= 225.0 && heading < 305.0 ? this.dFieldWidth - this.dRobotMargeX - (this.dFieldWidth - x) : (heading >= 135.0 && heading < 225.0 ? this.dFieldHeight - this.dRobotMargeY - (this.dFieldHeight - y) : this.dFieldWidth - this.dRobotMargeX - x));
            if (distance > 31.0) {
                if (distance > 231.0) {
                    this.setAhead(200.0);
                } else {
                    this.setAhead(distance - 31.0);
                    this.state = 1;
                }
            } else {
                this.turnLeft(90.0);
                this.setAhead(distance);
            }
            this.execute();
        } else {
            this.setTurnLeft(90.0);
            this.setAhead(90.0);
            this.state = 0;
            this.execute();
        }
    }

    private void GoToWall() {
        double y = 0.0;
        double mindistance = 0.0;
        double minheading = 0.0;
        double turnleft = 0.0;
        double turnright = 0.0;
        TurnCompleteCondition FinishedTurning = new TurnCompleteCondition((AdvancedRobot)this);
        double x = this.getX();
        y = this.getY();
        mindistance = x - this.dRobotMargeX;
        minheading = 270.0;
        if (mindistance > this.dFieldWidth - x - this.dRobotMargeX) {
            mindistance = this.dFieldWidth - x - this.dRobotMargeX;
            minheading = 90.0;
        }
        if (mindistance > y - this.dRobotMargeY) {
            mindistance = y - this.dRobotMargeY;
            minheading = 180.0;
        }
        if (mindistance > this.dFieldHeight - y - this.dRobotMargeY) {
            mindistance = this.dFieldHeight - y - this.dRobotMargeY;
            minheading = 0.0;
        }
        turnright = (minheading - this.getHeading()) % 360.0;
        turnleft = (this.getHeading() - minheading) % 360.0;
        if (turnright < 0.0) {
            turnright += 360.0;
        }
        if (turnleft < 0.0) {
            turnleft += 360.0;
        }
        if (turnright < turnleft) {
            this.setTurnRight(turnright);
        } else {
            this.setTurnLeft(turnleft);
        }
        this.waitFor((Condition)FinishedTurning);
        this.setAhead(mindistance);
    }

    public void run() {
        MoveCompleteCondition FinishedMoving = new MoveCompleteCondition((AdvancedRobot)this);
        TurnCompleteCondition FinishedTurning = new TurnCompleteCondition((AdvancedRobot)this);
        this.setColors(Color.cyan, Color.yellow, Color.red);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.dFieldHeight = this.getBattleFieldHeight();
        this.dFieldWidth = this.getBattleFieldWidth();
        this.dRobotMargeY = this.getHeight() / 2.0 + this.dFieldHeight / 100.0;
        this.dRobotMargeX = this.getWidth() / 2.0 + this.dFieldWidth / 100.0;
        this.dMaxEnemyDistance = Math.sqrt(this.dFieldHeight * this.dFieldHeight + this.dFieldWidth * this.dFieldWidth);
        this.out.println("Fieldwidth : " + this.dFieldWidth + " MargeX : " + this.dRobotMargeX);
        this.out.println("Fieldheight : " + this.dFieldHeight + " MargeY : " + this.dRobotMargeY);
        this.out.println("MaxEnemyDistance : " + this.dMaxEnemyDistance);
        this.setMaxVelocity(8.0);
        this.setTurnRadarLeft(360.0);
        this.GoToWall();
        while (true) {
            this.setTurnRadarLeft(360.0);
            if (!this.indMovement) continue;
            this.waitFor((Condition)FinishedMoving);
            this.waitFor((Condition)FinishedTurning);
            if (this.isAtWall() != 0) {
                this.GoToCorner();
                continue;
            }
            this.out.println("...oops, not at the wall....");
            if (this.state != 10 && this.state != 11) {
                this.GoToWall();
                continue;
            }
            this.GoToCorner();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if (this.indScanning) {
            double dy;
            double dx;
            double w = e.getHeadingRadians() - lastEnemyHeading;
            lastEnemyHeading = e.getHeadingRadians();
            double absbearing = e.getBearingRadians() + this.getHeadingRadians();
            double eX = e.getDistance() * Math.sin(absbearing);
            double eY = e.getDistance() * Math.cos(absbearing);
            double db = 0.0;
            double ww = lastEnemyHeading;
            do {
                dx = e.getVelocity() * Math.sin(ww);
                dy = e.getVelocity() * Math.cos(ww);
                ww += w;
            } while ((db += 11.0) < Math.sqrt((eX += dx) * eX + (eY += dy) * eY));
            this.setTurnGunRightRadians(Math.asin(Math.sin(Math.atan2(eX, eY) - this.getGunHeadingRadians())));
            if (this.indFiring && this.getGunHeat() == 0.0 && this.getEnergy() > 0.0) {
                this.fire(3.0);
            }
            this.setTurnRadarLeft(360.0);
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        double bulletbearing = e.getBearing();
        if ((bulletbearing > -15.0 && bulletbearing < 15.0 || bulletbearing < -165.0 || bulletbearing > 165.0) && this.state != 10 && this.state != 11) {
            this.state = 10;
        }
    }

    public void onHitWall(HitWallEvent e) {
        this.out.println("Hit the wall!!!! ");
    }
}

