/*
 * Decompiled with CFR 0.152.
 */
package pedersen.core;

import pedersen.debug.DebuggableBase;
import pedersen.physics.Firepower;
import pedersen.util.Conversions;

public class EnergyTracker
extends DebuggableBase {
    private double roundEnergyLossDueToShotsFired = 0.0;
    private double roundEnergyLossDueToDamageTaken = 0.0;
    private double roundEnergyGainDueToDamageDealt = 0.0;
    private double roundEnergyLossUnexplained = 0.0;
    private double battleEnergyLossDueToShotsFired = 0.0;
    private double battleEnergyLossDueToDamageTaken = 0.0;
    private double battleEnergyGainDueToDamageDealt = 0.0;
    private double battleEnergyLossUnexplained = 0.0;
    private double totalBulletDamageDealt = 0.0;
    private static double totalDamageSustainedFromHittingRobots = 0.0;

    public void receiveBulletDamage(double damage) {
        this.roundEnergyLossDueToDamageTaken += damage;
    }

    public void receiveRamDamage(double damage) {
        this.roundEnergyLossDueToDamageTaken += damage;
        totalDamageSustainedFromHittingRobots += damage;
    }

    public void dealBulletDamage(double firepower) {
        this.roundEnergyGainDueToDamageDealt += Conversions.getEnergyRewardFromFirepower(firepower);
        this.totalBulletDamageDealt += Conversions.getBulletDamageFromFirepower(firepower);
    }

    public void onRound() {
        this.battleEnergyLossDueToShotsFired += this.roundEnergyLossDueToShotsFired;
        this.battleEnergyLossDueToDamageTaken += this.roundEnergyLossDueToDamageTaken;
        this.battleEnergyGainDueToDamageDealt += this.roundEnergyGainDueToDamageDealt;
        this.battleEnergyLossUnexplained += this.roundEnergyLossUnexplained;
        this.roundEnergyLossDueToShotsFired = 0.0;
        this.roundEnergyLossDueToDamageTaken = 0.0;
        this.roundEnergyGainDueToDamageDealt = 0.0;
        this.roundEnergyLossUnexplained = 0.0;
    }

    @Override
    public String description() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("\n\u00a4 ").append("Energy loss - shots fired: " + super.trim(this.battleEnergyLossDueToShotsFired));
        buffer.append("\n\u00a4 ").append("Energy loss - damage taken: " + super.trim(this.battleEnergyLossDueToDamageTaken));
        buffer.append("\n\u00a4 ").append("Energy gain - damage bonus: " + super.trim(this.battleEnergyGainDueToDamageDealt));
        buffer.append("\n\u00a4 ").append("Energy loss - unexplained: " + super.trim(this.battleEnergyLossUnexplained));
        return buffer.toString();
    }

    public double getTotalExpectedEnergy() {
        return 100.0 + this.roundEnergyGainDueToDamageDealt - this.roundEnergyLossDueToDamageTaken - this.roundEnergyLossDueToShotsFired - this.roundEnergyLossUnexplained;
    }

    public void addUnexplainedEnergyLoss(double energy) {
        this.roundEnergyLossUnexplained += energy;
    }

    public void addShotEnergyExpenditure(Firepower firepower) {
        this.roundEnergyLossDueToShotsFired += firepower.firepower();
    }
}

