/*
 * Decompiled with CFR 0.152.
 */
package alk.lap.utils;

import alk.lap.SpottingRobotI;
import alk.lap.utils.Job;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class Cronner {
    public static final String PREFIX = "t=";
    private SpottingRobotI proud;
    private HashMap<String, Vector<Job>> allJobs = new HashMap();

    public Cronner(SpottingRobotI proud) {
        this.proud = proud;
    }

    public void checkAndExecuteJobs() {
        Vector<Job> joblist = this.allJobs.remove(PREFIX + this.proud.getTime());
        if (joblist != null) {
            for (Job job : joblist) {
                job.doJob(this.proud);
            }
        }
    }

    public Job addSingleJob(long time, Job job) {
        Vector<Job> joblist = this.allJobs.get(PREFIX + time);
        if (joblist == null) {
            joblist = new Vector();
        }
        joblist.add(job);
        this.allJobs.put(PREFIX + time, joblist);
        return job;
    }

    public Job addRepeatJob(long interval, Job job) {
        return this.addSingleJob(interval + this.proud.getTime(), new RepeatJob(interval, job));
    }

    public void deleteJob(Job job) {
        Iterator<String> iter = this.allJobs.keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next().toString();
            Vector<Job> joblist = this.allJobs.get(key);
            joblist.remove(job);
        }
    }

    private class RepeatJob
    implements Job {
        private Job job;
        private long interval;

        public RepeatJob(long interval, Job job) {
            this.job = job;
            this.interval = interval;
        }

        public void doJob(SpottingRobotI proud) {
            this.job.doJob(proud);
            Cronner.this.addSingleJob(proud.getTime() + this.interval, this);
        }

        public String describeYourself() {
            return "doing each " + this.interval + ":" + this.job.describeYourself();
        }
    }

    public class MsgJob
    implements Job {
        private String msg;

        public MsgJob(String msg) {
            this.msg = msg;
        }

        public void doJob(SpottingRobotI proud) {
            proud.log(this.msg);
        }

        public String describeYourself() {
            return "telling that '" + this.msg + "'";
        }
    }
}

