/*
 * Decompiled with CFR 0.152.
 */
package lazarecki.robot.painter;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import lazarecki.data.DataSegmentWave;
import lazarecki.data.DataSegmentation;
import lazarecki.robot.painter.AbstractWavePainterModule;
import lazarecki.util.RoboUtils;
import lazarecki.wave.Wave;
import robocode.util.Utils;

public class DataWavePainterModule
extends AbstractWavePainterModule {
    private List<DataSegmentWave> waves;
    private Color lowestValueColor;
    private Color highestValueColor;

    public DataWavePainterModule(List<DataSegmentWave> waves) {
        this.waves = waves;
        this.setLowestValueColor(RoboUtils.cloneTransparentColor(Color.BLUE, 192));
        this.setHighestValueColor(RoboUtils.cloneTransparentColor(Color.YELLOW, 192));
    }

    public Color getLowestValueColor() {
        return this.lowestValueColor;
    }

    public void setLowestValueColor(Color lowestValueColor) {
        this.lowestValueColor = lowestValueColor;
    }

    public Color getHighestValueColor() {
        return this.highestValueColor;
    }

    public void setHighestValueColor(Color highestValueColor) {
        this.highestValueColor = highestValueColor;
    }

    @Override
    public void onPaint(Graphics2D g) {
        for (DataSegmentWave wave : this.waves) {
            this.onPaintDataWave(g, wave);
        }
    }

    protected void onPaintDataWave(Graphics2D g, DataSegmentWave wave) {
        this.onPaintWave(g, wave);
        double waveDistance = wave.getDistanceTraveled(this.getRobot().getTime());
        Line2D.Double bulletPath = new Line2D.Double(RoboUtils.projectPoint(wave.getShooter().getPosition(), wave.getAbsoluteBestFireAngle(), 35.0), RoboUtils.projectPoint(wave.getShooter().getPosition(), wave.getAbsoluteBestFireAngle(), 35.0 + Math.max(waveDistance - 35.0, 0.0)));
        Point2D bulletPoint = RoboUtils.projectPoint(wave.getShooter().getPosition(), wave.getAbsoluteBestFireAngle(), waveDistance);
        Rectangle2D.Double bulletRect = new Rectangle2D.Double(bulletPoint.getX() - 10.0, bulletPoint.getY() - 10.0, 20.0, 20.0);
        g.draw(bulletPath);
        g.draw(bulletRect);
        DataSegmentation.DataQueryResult dataSegment = wave.getDataSegment();
        int i = 0;
        while (i < dataSegment.getSegments()) {
            double guessFactor = Wave.calculateGuessFactor(dataSegment.getSegments(), i);
            double absFireAngle = Utils.normalAbsoluteAngle((double)(wave.getAbsoluteFireAngle() + Wave.calculateFireAngleOffset(wave.getDirection(), guessFactor, wave.getFirePower())));
            Point2D point = RoboUtils.projectPoint(wave.getShooter(), absFireAngle, waveDistance - 8.0);
            Ellipse2D.Double circle = new Ellipse2D.Double(point.getX() - 4.0, point.getY() - 4.0, 8.0, 8.0);
            g.setColor(RoboUtils.createMixedColor(this.getLowestValueColor(), this.getHighestValueColor(), dataSegment.getValueAt(i)));
            g.fill(circle);
            ++i;
        }
    }
}

