/*
 * Decompiled with CFR 0.152.
 */
package MyRobots;

import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Attack {
    private AdvancedRobot robot;
    public static final byte TYPE_FIXED = 0;
    public static final byte TYPE_LINEAR = 1;

    public Attack(AdvancedRobot r) {
        this.robot = r;
    }

    public double absoluteAngle(double r) {
        if ((r %= 360.0) < 0.0) {
            r = 360.0 + r;
        }
        return r;
    }

    public double setGunVector(double x, double y) {
        double targetAngle = this.absoluteAngle(Math.toDegrees(Math.atan2(x, y)));
        double errorAngle = targetAngle - this.robot.getGunHeading();
        errorAngle = Utils.normalRelativeAngleDegrees((double)errorAngle);
        this.robot.setTurnGunRight(errorAngle);
        return errorAngle;
    }

    public double setFireVector(double x, double y) {
        double bulletSpeed = Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0));
        if (this.setGunVector(x, y) < 5.0) {
            double bulletPower = (20.0 - bulletSpeed) / 3.0;
            if (bulletPower < 0.1 || 3.0 < bulletPower) {
                return Double.NaN;
            }
            try {
                this.robot.setFireBullet(bulletPower);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return bulletPower;
        }
        return 0.0;
    }

    public double setFixedAim(ScannedRobotEvent e) {
        double absoluteBearing = e.getBearing() + this.robot.getHeading();
        double bearingFromGun = Utils.normalRelativeAngleDegrees((double)(absoluteBearing - this.robot.getGunHeading()));
        this.robot.setTurnGunRight(bearingFromGun);
        return -0.0022307692307692306 * e.getDistance() + 3.4461538461538463;
    }

    public double setLinearAim(ScannedRobotEvent e) {
        double Eb = -0.0022307692307692306 * e.getDistance() + 3.4461538461538463;
        double s = this.getSwingSpeed(e);
        if (3.0 < Eb) {
            Eb = 3.0;
        } else if (Eb < 0.1) {
            Eb = 0.1;
        }
        double Vb = -3.0 * Eb + 20.0;
        double c = Math.sqrt(Vb * Vb - s * s);
        double r = Math.toRadians(-this.getAbsoluteBearing(e));
        double x = s * Math.cos(r) - c * Math.sin(r);
        double y = s * Math.sin(r) + c * Math.cos(r);
        this.setGunVector(x, y);
        return Eb;
    }

    public double getSwingSpeed(ScannedRobotEvent e) {
        double bearingFromRival = Utils.normalRelativeAngleDegrees((double)(this.robot.getHeading() + e.getBearing() - e.getHeading() + 180.0));
        double swingSpeed = e.getVelocity() * Math.sin(Math.toRadians(bearingFromRival));
        return swingSpeed;
    }

    public double getAbsoluteBearing(ScannedRobotEvent e) {
        double r = this.robot.getHeading() + e.getBearing();
        if ((r %= 360.0) < 0.0) {
            r = 360.0 + r;
        }
        return r;
    }
}

