/*
 * Decompiled with CFR 0.152.
 */
package gre.svman4.attack;

import gre.svman4.attack.AttackLog;
import gre.svman4.useful.RobotState;
import java.awt.Color;
import java.awt.Graphics2D;
import robocode.StatusEvent;

public class Attack {
    public boolean _isPainted = false;
    public long _coverDistance;
    public AttackLog _hitTargetLog;
    public AttackLog _targetLog;
    public RobotState _targetRobot;
    public AttackLog _shooterLog;
    public RobotState _shootingRobot;
    public long _startTime;
    public double _velocity;
    public long _hitTime;
    private static final int ERROR_DISTANCE_FOR_COVERDISTANCE = 18;

    public Attack() {
    }

    public Attack(long time, RobotState me, RobotState target) {
        this();
        this._startTime = time;
        this._shootingRobot = me;
        this._shooterLog = new AttackLog(me);
        this._targetRobot = target;
        this._targetLog = new AttackLog(target);
    }

    public boolean goesToTarget() {
        double distanceToEnemy = this._shooterLog.robotPoint.distance(this._targetRobot);
        return distanceToEnemy < (double)(this._coverDistance - 18L);
    }

    public void saveTargetInfo(long time) {
        this._hitTargetLog = new AttackLog(this._targetRobot);
        this._hitTime = time;
    }

    public void onPaint(Graphics2D paint) {
        if (!this._isPainted) {
            return;
        }
        paint.setColor(Color.gray);
        paint.drawOval((int)(this._shooterLog.robotPoint.x - (double)this._coverDistance), (int)(this._shooterLog.robotPoint.y - (double)this._coverDistance), (int)(2L * this._coverDistance), (int)(2L * this._coverDistance));
        paint.fillOval((int)(this._shooterLog.robotPoint.x - 2.0), (int)(this._shooterLog.robotPoint.y - 2.0), 4, 4);
        paint.fillOval((int)(this._targetRobot.x - 2.0), (int)(this._targetRobot.y - 2.0), 4, 4);
    }

    public void onStatus(StatusEvent event) {
        this._coverDistance = (long)((double)(event.getTime() - this._startTime) * this._velocity);
    }

    public void timeNowIs(long timeNow) {
        this._coverDistance = (long)((double)(timeNow - this._startTime) * this._velocity);
    }

    public String toString() {
        StringBuilder text = new StringBuilder(100);
        text.append(this._startTime).append(",");
        text.append(this._hitTime).append(",");
        text.append(this._shootingRobot.name).append(",");
        text.append(this._shooterLog.toString()).append(",");
        text.append(this._targetRobot.name).append(",");
        text.append(this._targetLog.toString()).append(",");
        text.append(this._hitTargetLog.toString()).append(",");
        text.append("\n");
        return text.toString();
    }
}

