/*
 * Decompiled with CFR 0.152.
 */
package rampancy.standard;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import rampancy.RMovementManager;
import rampancy.RampantRobot;
import rampancy.standard.MoveStruct;
import rampancy.util.RBattlefield;
import rampancy.util.REnemyRobot;
import rampancy.util.RPoint;
import rampancy.util.RRobotState;
import rampancy.util.RUtil;
import rampancy.util.movement.MovSim;
import rampancy.util.movement.MovSimStat;
import rampancy.util.movement.RMoveChoice;
import rampancy.util.wave.REnemyWave;
import rampancy.util.wave.REnemyWaveWithStats;
import robocode.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDefaultMovementManager
implements RMovementManager {
    public static final double MIN_DISTANCE = 230.0;
    public static final double MIN_WAVE_ORBIT_DISTANCE = 230.0;
    public static final Color CW_COLOR = new Color(0, 0, 255);
    public static final Color CCW_COLOR = new Color(0, 200, 200);
    private ArrayList<RMoveChoice> examinedMovementChoices = new ArrayList();
    private REnemyWave dummyWave;
    private RampantRobot reference;
    private int direction;

    public RDefaultMovementManager(RampantRobot reference) {
        this.reference = reference;
        this.direction = 1;
    }

    @Override
    public void updateReference(RampantRobot reference) {
        this.reference = reference;
    }

    @Override
    public RMoveChoice computeBestMove(REnemyRobot enemy) {
        REnemyWave wave = RampantRobot.getWaveManager().getClosestEnemyWave(this.reference.getLocation());
        RMoveChoice best = null;
        if (wave != null && !wave.isVirtual()) {
            RRobotState currentState = this.reference.getCurrentState();
            ArrayList<RMoveChoice> movementChoices = this.getBestMove(new MoveStruct(this.reference, enemy, wave));
            double danger = 5000000.0;
            this.examinedMovementChoices = new ArrayList<RMoveChoice>(movementChoices);
            if (this.examinedMovementChoices.isEmpty()) {
                return null;
            }
            if (wave instanceof REnemyWaveWithStats) {
                REnemyWaveWithStats statWave = (REnemyWaveWithStats)wave;
                for (RMoveChoice choice : this.examinedMovementChoices) {
                    choice.danger = 0.0;
                }
                for (RMoveChoice choice : this.examinedMovementChoices) {
                    double locDanger = statWave.getDangerForLocation(choice.destination, 61);
                    double dist = enemy.getCurrentState().location.distance(choice.destination);
                    if (enemy.getPreferredSafeDistance() > dist) {
                        locDanger += 0.5 * RUtil.square(dist - enemy.getPreferredSafeDistance());
                    }
                    for (RMoveChoice testChoice : this.examinedMovementChoices) {
                        if (!RUtil.pointOnRobotPoint(choice.destination, testChoice.destination)) continue;
                        testChoice.danger += locDanger;
                    }
                }
            }
            Collections.sort(this.examinedMovementChoices, new Comparator<RMoveChoice>(){

                @Override
                public int compare(RMoveChoice o1, RMoveChoice o2) {
                    return RUtil.sign(o1.danger - o2.danger);
                }
            });
            double minDanger = this.examinedMovementChoices.get((int)0).danger;
            int i = 0;
            while (i < this.examinedMovementChoices.size()) {
                if (this.examinedMovementChoices.get((int)i).danger > 0.1 + minDanger) break;
                ++i;
            }
            List<RMoveChoice> sub = this.examinedMovementChoices.subList(0, i);
            Collections.shuffle(sub);
            this.examinedMovementChoices = new ArrayList<RMoveChoice>(sub);
            this.direction = this.examinedMovementChoices.get((int)0).direction;
            return this.examinedMovementChoices.get(0);
        }
        this.dummyWave = new REnemyWaveWithStats(enemy);
        ArrayList<RMoveChoice> movementChoices = this.getBestOrbitMove(new MoveStruct(this.reference, enemy, this.dummyWave));
        if (movementChoices.isEmpty()) {
            return null;
        }
        this.examinedMovementChoices = new ArrayList<RMoveChoice>(movementChoices);
        if (Math.random() < 0.01) {
            this.direction = -this.direction;
        }
        int tempDirection = this.direction == 0 ? 1 : this.direction;
        for (RMoveChoice choice : this.examinedMovementChoices) {
            choice.danger = 0.0;
        }
        for (RMoveChoice choice : this.examinedMovementChoices) {
            double locDanger = RampantRobot.getStatisticsManager().getMovementStatistics().getDanger(wave, choice.destination);
            for (RMoveChoice testChoice : this.examinedMovementChoices) {
                if (!RUtil.pointOnRobotPoint(choice.destination, testChoice.destination)) continue;
                testChoice.danger += locDanger;
            }
        }
        Collections.sort(this.examinedMovementChoices, new Comparator<RMoveChoice>(){

            @Override
            public int compare(RMoveChoice o1, RMoveChoice o2) {
                return (int)(o1.guessFactor - o2.guessFactor);
            }
        });
        for (RMoveChoice choice : this.examinedMovementChoices) {
            if (choice.direction != tempDirection) continue;
            return choice;
        }
        return best;
    }

    @Override
    public void draw(Graphics2D g) {
        REnemyWave wave = RampantRobot.getWaveManager().getClosestEnemyWave(this.reference.getLocation());
        if (wave == null) {
            wave = this.dummyWave;
        }
        if (wave == null) {
            return;
        }
        double goAngle = RUtil.computeOrbitAngle(this.reference.getCopyOfLocation(), wave, 0.0, 1);
        double goAngleCCW = RUtil.computeOrbitAngle(this.reference.getCopyOfLocation(), wave, 0.0, -1);
        RPoint cw = RUtil.project(this.reference.getCopyOfLocation(), goAngle, 150.0);
        RPoint ccw = RUtil.project(this.reference.getCopyOfLocation(), goAngleCCW, 150.0);
        g.setColor(Color.blue);
        RUtil.drawOval(this.reference.getCopyOfLocation(), 150, g);
        g.setColor(CW_COLOR);
        RUtil.drawOval(cw, 25, g);
        RUtil.fillOval(cw, 3, g);
        g.setColor(CCW_COLOR);
        RUtil.drawOval(ccw, 25, g);
        RUtil.fillOval(ccw, 3, g);
        g.setColor(Color.blue);
        for (RMoveChoice choice : this.examinedMovementChoices) {
            choice.draw(g);
        }
    }

    private ArrayList<RMoveChoice> getBestMove(MoveStruct solution) {
        ArrayList<RMoveChoice> choices = new ArrayList<RMoveChoice>();
        this.logLocation(solution.reference.getLocation(), 0, solution.reference.getCurrentState().directionTraveling, solution, choices);
        this.simulateDirection(solution.reference.getLocation(), solution.reference.getHeadingRadians(), solution.reference.getVelocity(), 1, 0, solution, choices);
        this.simulateDirection(solution.reference.getLocation(), solution.reference.getHeadingRadians(), solution.reference.getVelocity(), -1, 0, solution, choices);
        return choices;
    }

    private ArrayList<RMoveChoice> getBestOrbitMove(MoveStruct solution) {
        ArrayList<RMoveChoice> choices = new ArrayList<RMoveChoice>();
        this.simulateOrbitDirection(solution.reference.getLocation(), solution.reference.getHeadingRadians(), solution.reference.getVelocity(), 1, 0, solution, choices);
        this.simulateOrbitDirection(solution.reference.getLocation(), solution.reference.getHeadingRadians(), solution.reference.getVelocity(), -1, 0, solution, choices);
        return choices;
    }

    private void simulateDirection(RPoint fromLocation, double fromHeading, double fromVelocity, int direction, int timeOffset, MoveStruct solution, ArrayList<RMoveChoice> movementChoices) {
        if (solution.wave.intercepted(fromLocation, timeOffset)) {
            return;
        }
        RPoint orbitLocation = solution.wave.getOrigin();
        if (solution.enemy.getCurrentState().distance < solution.enemy.getPreferredSafeDistance()) {
            orbitLocation = solution.enemy.getCurrentState().location;
        }
        double orbitDistance = orbitLocation.distance(fromLocation);
        double goAngle = RUtil.computeAbsoluteBearing(orbitLocation, fromLocation);
        double attackAngle = this.computeAttackAngle(goAngle, fromLocation, fromHeading, fromVelocity, direction, timeOffset, solution);
        goAngle = RUtil.wallSmoothing(fromLocation, goAngle + (1.5707963267948966 + attackAngle) * (double)direction, direction, orbitDistance);
        MovSimStat next = this.predictPosition(fromLocation, fromHeading, goAngle, fromVelocity, 8.0, direction);
        RPoint nextLocation = new RPoint(next.x, next.y);
        this.logLocation(nextLocation, timeOffset, direction, solution, movementChoices);
        this.simulateDirection(nextLocation, next.h, next.v, direction, timeOffset + 1, solution, movementChoices);
    }

    private void simulateOrbitDirection(RPoint fromLocation, double fromHeading, double fromVelocity, int direction, int timeOffset, MoveStruct solution, ArrayList<RMoveChoice> movementChoices) {
        if (solution.wave.intercepted(fromLocation, timeOffset)) {
            return;
        }
        RPoint orbitLocation = solution.enemy.getCurrentState().location;
        double orbitDistance = orbitLocation.distance(fromLocation);
        double goAngle = RUtil.computeAbsoluteBearing(orbitLocation, fromLocation);
        double attackAngle = this.computeAttackAngle(goAngle, fromLocation, fromHeading, fromVelocity, direction, timeOffset, solution);
        goAngle = RUtil.wallSmoothing(fromLocation, goAngle + (1.5707963267948966 + attackAngle) * (double)direction, direction, orbitDistance);
        MovSimStat next = this.predictPosition(fromLocation, fromHeading, goAngle, fromVelocity, 8.0, direction);
        RPoint nextLocation = new RPoint(next.x, next.y);
        this.logOrbitLocation(nextLocation, timeOffset, direction, solution, movementChoices);
        this.simulateOrbitDirection(nextLocation, next.h, next.v, direction, timeOffset + 1, solution, movementChoices);
    }

    private void logLocation(RPoint location, int timeOffset, int direction, MoveStruct solution, ArrayList<RMoveChoice> movementChoices) {
        REnemyWave wave = solution.wave;
        double danger = 0.0;
        if (wave instanceof REnemyWaveWithStats) {
            REnemyWaveWithStats statWave = (REnemyWaveWithStats)wave;
            danger = statWave.getDangerForLocation(location, 61);
        } else {
            danger = RampantRobot.getStatisticsManager().getMovementStatistics().getDanger(wave, location);
        }
        if (location.distance(solution.enemy.getLastState().location) < solution.enemy.getPreferredSafeDistance()) {
            danger += 100000.0 / RUtil.square(location.distance(wave.getCreator().getCurrentState().location));
        }
        int factor = RUtil.getFactorIndex(wave, location, 61);
        RPoint orbitLocation = solution.wave.getOrigin();
        if (solution.enemy.getCurrentState().distance < solution.enemy.getPreferredSafeDistance()) {
            orbitLocation = solution.enemy.getCurrentState().location;
        }
        double orbitDistance = orbitLocation.distance(location);
        double goAngle = RUtil.computeAbsoluteBearing(orbitLocation, solution.reference.getLocation());
        double attackAngle = this.computeAttackAngle(goAngle, solution.reference.getLocation(), solution.reference.getHeadingRadians(), solution.reference.getVelocity(), direction, timeOffset, solution);
        goAngle = RUtil.wallSmoothing(solution.reference.getLocation(), goAngle + (1.5707963267948966 + attackAngle) * (double)direction, direction, orbitDistance);
        RMoveChoice moveChoice = new RMoveChoice(location, goAngle, -1.0, 8.0, danger, factor, timeOffset, direction);
        moveChoice.color = direction > 0 ? CW_COLOR : CCW_COLOR;
        movementChoices.add(moveChoice);
    }

    private void logOrbitLocation(RPoint location, int timeOffset, int direction, MoveStruct solution, ArrayList<RMoveChoice> movementChoices) {
        double danger = 0.0;
        RPoint orbitLocation = solution.enemy.getCurrentState().location;
        if (location.distance(orbitLocation) < solution.enemy.getPreferredSafeDistance()) {
            danger += 100000.0 / RUtil.square(location.distance(orbitLocation));
        }
        double orbitDistance = orbitLocation.distance(location);
        double goAngle = RUtil.computeAbsoluteBearing(orbitLocation, solution.reference.getLocation());
        double attackAngle = this.computeAttackAngle(goAngle, solution.reference.getLocation(), solution.reference.getHeadingRadians(), solution.reference.getVelocity(), direction, timeOffset, solution);
        goAngle = RUtil.wallSmoothing(solution.reference.getLocation(), goAngle + (1.5707963267948966 + attackAngle) * (double)direction, direction, orbitDistance);
        RMoveChoice moveChoice = new RMoveChoice(location, goAngle, -1.0, 8.0, danger, 0.0, timeOffset, direction);
        moveChoice.color = direction > 0 ? CW_COLOR : CCW_COLOR;
        movementChoices.add(moveChoice);
    }

    private double computeAttackAngle(double goAngle, RPoint fromLocation, double fromHeading, double fromVelocity, double direction, int timeOffset, MoveStruct solution) {
        double attackAngle = 0.0;
        REnemyRobot enemy = solution.enemy;
        RRobotState enemyState = enemy.getLastState();
        if (enemyState == null) {
            enemyState = enemy.getCurrentState();
        }
        if (fromLocation.distance(enemyState.location) < enemy.getPreferredSafeDistance()) {
            int enemyDirection = enemyState.directionTraveling;
            double orbitAngle = goAngle + 1.5707963267948966 * direction;
            if ((double)enemyDirection != direction) {
                double delta1 = Math.abs(orbitAngle - enemyState.heading);
                double delta2 = Math.abs(orbitAngle - Utils.normalAbsoluteAngle((double)(enemyState.heading + Math.PI)));
                attackAngle = -Math.min(delta1, delta2);
            } else {
                attackAngle = -0.05;
            }
        }
        return attackAngle;
    }

    private MovSimStat predictPosition(RPoint fromLocation, double currentHeading, double desiredHeading, double currentVelocity, double maxVelocity, double direction) {
        double angleToTurn = desiredHeading - currentHeading;
        int moveDirection = 1;
        if (Math.cos(angleToTurn) < 0.0) {
            angleToTurn += Math.PI;
            moveDirection = -1;
        }
        angleToTurn = Utils.normalRelativeAngle((double)angleToTurn);
        RBattlefield bf = RampantRobot.getGlobalBattlefield();
        MovSimStat[] nextTick = MovSim.futurePos(1, fromLocation.x, fromLocation.y, currentVelocity, maxVelocity, currentHeading, 1000 * moveDirection, angleToTurn, 10.0, bf.width, bf.height);
        return nextTick[0];
    }
}

