/*
 * Decompiled with CFR 0.152.
 */
package ags.utils.dataStructures.trees.thirdGenKD;

import java.util.Arrays;

class KdNode<T> {
    protected int dimensions;
    protected int bucketCapacity;
    protected int size;
    protected double[][] points;
    protected Object[] data;
    protected KdNode<T> left;
    protected KdNode<T> right;
    protected int splitDimension;
    protected double splitValue;
    protected double[] minBound;
    protected double[] maxBound;
    protected boolean singlePoint;

    protected KdNode(int dimensions, int bucketCapacity) {
        this.dimensions = dimensions;
        this.bucketCapacity = bucketCapacity;
        this.size = 0;
        this.singlePoint = true;
        this.points = new double[bucketCapacity + 1][];
        this.data = new Object[bucketCapacity + 1];
    }

    public int size() {
        return this.size;
    }

    public boolean isLeaf() {
        return this.points != null;
    }

    public void addPoint(double[] point, T value) {
        KdNode<T> cursor = this;
        while (!cursor.isLeaf()) {
            cursor.extendBounds(point);
            ++cursor.size;
            if (point[cursor.splitDimension] > cursor.splitValue) {
                cursor = cursor.right;
                continue;
            }
            cursor = cursor.left;
        }
        cursor.addLeafPoint(point, value);
    }

    public void addLeafPoint(double[] point, T value) {
        this.points[this.size] = point;
        this.data[this.size] = value;
        this.extendBounds(point);
        ++this.size;
        if (this.size == this.points.length - 1) {
            if (this.calculateSplit()) {
                this.splitLeafNode();
            } else {
                this.increaseLeafCapacity();
            }
        }
    }

    private void addLeafPointNoSplit(double[] point, T value) {
        this.points[this.size] = point;
        this.data[this.size] = value;
        this.extendBounds(point);
        ++this.size;
    }

    private boolean checkBounds(double[] point) {
        for (int i = 0; i < this.dimensions; ++i) {
            if (point[i] > this.maxBound[i]) {
                return false;
            }
            if (!(point[i] < this.minBound[i])) continue;
            return false;
        }
        return true;
    }

    private void extendBounds(double[] point) {
        if (this.minBound == null) {
            this.minBound = Arrays.copyOf(point, this.dimensions);
            this.maxBound = Arrays.copyOf(point, this.dimensions);
            return;
        }
        for (int i = 0; i < this.dimensions; ++i) {
            if (Double.isNaN(point[i])) {
                if (!Double.isNaN(this.minBound[i]) || !Double.isNaN(this.maxBound[i])) {
                    this.singlePoint = false;
                }
                this.minBound[i] = Double.NaN;
                this.maxBound[i] = Double.NaN;
                continue;
            }
            if (this.minBound[i] > point[i]) {
                this.minBound[i] = point[i];
                this.singlePoint = false;
                continue;
            }
            if (!(this.maxBound[i] < point[i])) continue;
            this.maxBound[i] = point[i];
            this.singlePoint = false;
        }
    }

    private void increaseLeafCapacity() {
        this.points = (double[][])Arrays.copyOf(this.points, this.points.length * 2);
        this.data = Arrays.copyOf(this.data, this.data.length * 2);
    }

    private boolean calculateSplit() {
        if (this.singlePoint) {
            return false;
        }
        double width = 0.0;
        for (int i = 0; i < this.dimensions; ++i) {
            double dwidth = this.maxBound[i] - this.minBound[i];
            if (Double.isNaN(dwidth)) {
                dwidth = 0.0;
            }
            if (!(dwidth > width)) continue;
            this.splitDimension = i;
            width = dwidth;
        }
        if (width == 0.0) {
            return false;
        }
        this.splitValue = (this.minBound[this.splitDimension] + this.maxBound[this.splitDimension]) * 0.5;
        if (this.splitValue == Double.POSITIVE_INFINITY) {
            this.splitValue = Double.MAX_VALUE;
        } else if (this.splitValue == Double.NEGATIVE_INFINITY) {
            this.splitValue = -1.7976931348623157E308;
        }
        if (this.splitValue == this.maxBound[this.splitDimension]) {
            this.splitValue = this.minBound[this.splitDimension];
        }
        return true;
    }

    private void splitLeafNode() {
        this.right = new KdNode<T>(this.dimensions, this.bucketCapacity);
        this.left = new KdNode<T>(this.dimensions, this.bucketCapacity);
        for (int i = 0; i < this.size; ++i) {
            double[] oldLocation = this.points[i];
            Object oldData = this.data[i];
            if (oldLocation[this.splitDimension] > this.splitValue) {
                this.right.addLeafPointNoSplit(oldLocation, oldData);
                continue;
            }
            this.left.addLeafPointNoSplit(oldLocation, oldData);
        }
        this.points = null;
        this.data = null;
    }
}

