/*
 * Decompiled with CFR 0.152.
 */
package ags.muse.base;

import ags.muse.base.Rules;
import ags.muse.base.StaticStorage;
import ags.muse.base.actors.BroadcastActor;
import ags.muse.base.actors.GunActor;
import ags.muse.base.actors.MovementActor;
import ags.muse.base.actors.RadarActor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import robocode.BattleEndedEvent;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.Event;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.MessageEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.StatusEvent;
import robocode.TeamRobot;
import robocode.WinEvent;

public abstract class BotBase
extends TeamRobot {
    private Rules rules;
    private GunActor gunActor;
    private MovementActor movementActor;
    private RadarActor radarActor;
    private BroadcastActor broadcastActor;
    private final List<Event> events = new ArrayList<Event>();
    private boolean running = false;

    public Rules getRules() {
        return this.rules;
    }

    public GunActor getGunActor() {
        return this.gunActor;
    }

    public MovementActor getMovementActor() {
        return this.movementActor;
    }

    public RadarActor getRadarActor() {
        return this.radarActor;
    }

    public BroadcastActor getBroadcastActor() {
        return this.broadcastActor;
    }

    private List<Event> getEvents() {
        ArrayList<Event> output = new ArrayList<Event>(this.events);
        this.events.clear();
        return output;
    }

    private void _onBattleEnded(BattleEndedEvent argo0) {
        StaticStorage.clear();
    }

    public void onCustomEvent(CustomEvent arg0) {
        this.events.add((Event)arg0);
    }

    public void onMessageReceived(MessageEvent arg0) {
        this.events.add((Event)arg0);
    }

    public void onBulletHit(BulletHitEvent arg0) {
        this.events.add((Event)arg0);
    }

    public void onBulletHitBullet(BulletHitBulletEvent arg0) {
        this.events.add((Event)arg0);
    }

    public void onBulletMissed(BulletMissedEvent arg0) {
        this.events.add((Event)arg0);
    }

    public void onDeath(DeathEvent arg0) {
        this.events.add((Event)arg0);
    }

    public void onHitByBullet(HitByBulletEvent arg0) {
        this.events.add((Event)arg0);
    }

    public void onHitRobot(HitRobotEvent arg0) {
        this.events.add((Event)arg0);
    }

    public void onHitWall(HitWallEvent arg0) {
        this.events.add((Event)arg0);
    }

    public void onRobotDeath(RobotDeathEvent arg0) {
        this.events.add((Event)arg0);
    }

    public void onScannedRobot(ScannedRobotEvent arg0) {
        this.events.add((Event)arg0);
    }

    public void onStatus(StatusEvent arg0) {
        this.events.add((Event)arg0);
    }

    public void onWin(WinEvent arg0) {
        this.events.add((Event)arg0);
    }

    public void onBattleEnded(BattleEndedEvent arg0) {
        this.events.add((Event)arg0);
        this._onBattleEnded(arg0);
    }

    public void onSkippedTurn(SkippedTurnEvent arg0) {
        this.events.add((Event)arg0);
        System.out.println("Warning! Turn skipped!");
    }

    public void broadcastMessage(Serializable s) throws IOException {
        super.broadcastMessage(s);
        this.events.add((Event)new MessageEvent(this.rules.NAME, s));
    }

    public void setColors(Color bodyColor, Color scanColor, Color gunColor, Color radarColor) {
        if (!this.running) {
            throw new UnsupportedOperationException("Bot must be running before colors may be set.");
        }
        this.setBodyColor(bodyColor);
        this.setScanColor(scanColor);
        this.setGunColor(gunColor);
        this.setRadarColor(radarColor);
    }

    public abstract void init();

    public abstract void runTick(List<Event> var1);

    public abstract void _onPaint(Graphics2D var1);

    private final void preInit() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.rules = new Rules(this);
        this.gunActor = new GunActor(this);
        this.movementActor = new MovementActor(this);
        this.radarActor = new RadarActor(this);
        this.broadcastActor = new BroadcastActor(this);
    }

    public void run() {
        if (this.running) {
            throw new UnsupportedOperationException("Main loop already running!");
        }
        this.running = true;
        this.preInit();
        this.init();
        while (true) {
            if (this.events.size() != 0) {
                this.runTick(this.getEvents());
            }
            this.execute();
        }
    }

    public void onPaint(Graphics2D g) {
        if (this.events.size() != 0) {
            this.runTick(this.getEvents());
        }
        this._onPaint(g);
    }
}

