/*
 * Decompiled with CFR 0.152.
 */
package starpkg;

import robocode.Bullet;
import starpkg.HelperTools;
import starpkg.Position;
import starpkg.StarViewerZ;
import starpkg.TargetPredict;

public class GunCtrl {
    private StarViewerZ robot = null;
    private HelperTools tools = null;
    private TargetPredict predict = null;
    public double firePower = 3.0;
    public boolean canFire = true;
    public final int MAX_ADJARRAY = 5;
    public double[] dirAdjArray = new double[5];
    public int dirAdjPtr = 0;

    public GunCtrl(StarViewerZ getInst) {
        this.robot = getInst;
        this.tools = this.robot.tools;
        this.predict = this.robot.predict;
        this.SetDirAdj();
    }

    public void SetGun() {
        double turnDegree = 0.0;
        this.firePower = this.predict.GetFirePower();
        Position targetPos = this.predict.GetNextPos(this.robot.getTime(), this.firePower);
        turnDegree = this.GetGunTurnDegree(targetPos);
        this.robot.setTurnGunRight(turnDegree);
        if (this.robot.getGunHeat() == 0.0) {
            if (!this.canFire) {
                this.canFire = true;
            } else if (turnDegree > -3.0 && turnDegree < 3.0 && this.robot.enemy.enemyMain.distance < 5000.0 && !this.robot.radarCtrl.roundScanning && this.firePower > 0.05) {
                this.Fire();
            }
        }
    }

    public void Fire() {
        Bullet bullet = this.robot.fireBullet(this.firePower);
        if (bullet != null) {
            this.robot.bulletList.Add(bullet, this.robot.enemy.enemyMain.name, this.robot.predict.enemyType);
        }
        ++this.dirAdjPtr;
        this.predict.OnFire();
        if (this.dirAdjPtr >= 5) {
            this.dirAdjPtr = 0;
        }
    }

    public double GetGunTurnAdjDegree(Position pos) {
        Position myPos = new Position(this.robot.getX(), this.robot.getY());
        double targetAngle = this.robot.getGunHeading() - myPos.DegreeTo(pos);
        return this.tools.NormalAngle(targetAngle += this.dirAdjArray[this.dirAdjPtr]);
    }

    public void SetDirAdj() {
        this.dirAdjArray[0] = -3.0;
        this.dirAdjArray[1] = 3.0;
        this.dirAdjArray[2] = -2.0;
        this.dirAdjArray[3] = 2.0;
        this.dirAdjArray[4] = 0.0;
    }

    public double GetGunTurnDegree(Position pos) {
        Position myPos = new Position(this.robot.getX(), this.robot.getY());
        double targetAngle = this.robot.getGunHeading() - myPos.DegreeTo(pos);
        return this.tools.NormalAngle(targetAngle);
    }
}

