/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import shrub.Bearing;
import shrub.BodyInstruction;
import shrub.Heading;
import shrub.Location;
import shrub.MovementModeAPI;
import shrub.RobotDataStore;
import shrub.Waypoint;

public class MovementModeMTW
implements MovementModeAPI {
    private final RobotDataStore mDataStore = RobotDataStore.getInstance();
    private Waypoint mWaypoint = new Waypoint(Location.ZERO_ZERO, 0L, 0L);
    private Location mRobotLocn = Location.ZERO_ZERO;
    private Heading mRobotHdng = Heading.ZERO;
    private long mTimeNow = 0L;
    private final boolean mAllowReversal;

    public MovementModeMTW(boolean allowReversal) {
        this.mAllowReversal = allowReversal;
    }

    public void setWaypoint(Waypoint waypoint) {
        this.mWaypoint = waypoint;
    }

    public void setRobotLocn(Location robotLocn) {
        this.mRobotLocn = robotLocn;
    }

    public void setRobotHdng(Heading robotHdng) {
        this.mRobotHdng = robotHdng;
    }

    public void setTimeNow(long timeNow) {
        this.mTimeNow = timeNow;
    }

    public BodyInstruction[] generateInstructions() {
        BodyInstruction doNothing = BodyInstruction.valueOf(BodyInstruction.NOTHING, 0.0);
        BodyInstruction[] instructs = new BodyInstruction[]{doNothing, doNothing, doNothing};
        Heading wayptHdng = Heading.valueOfFromTo(this.mRobotLocn, this.mWaypoint.getDestination());
        Bearing relBearing = Bearing.valueOfFromTo(this.mRobotHdng, wayptHdng);
        int index = 0;
        boolean reversing = false;
        if (relBearing.IsAligned()) {
            reversing = false;
        } else if (relBearing.IsOpposed() && this.mAllowReversal) {
            reversing = true;
        } else if (relBearing.IsForward() || relBearing.IsBackward() && !this.mAllowReversal) {
            reversing = false;
            double turnAmount = 10.0;
            if (relBearing.GetAbs() < turnAmount) {
                turnAmount = relBearing.GetAbs();
            }
            instructs[index] = relBearing.IsLeftward() ? BodyInstruction.valueOf(BodyInstruction.TURN_LEFT, turnAmount) : BodyInstruction.valueOf(BodyInstruction.TURN_RIGHT, turnAmount);
            ++index;
        } else if (relBearing.IsBackward() && this.mAllowReversal) {
            reversing = true;
            Bearing flippedBearing = Bearing.valueOfFlip(relBearing);
            double turnAmount = 10.0;
            if (flippedBearing.GetAbs() < turnAmount) {
                turnAmount = flippedBearing.GetAbs();
            }
            instructs[index] = flippedBearing.IsLeftward() ? BodyInstruction.valueOf(BodyInstruction.TURN_LEFT, turnAmount) : BodyInstruction.valueOf(BodyInstruction.TURN_RIGHT, turnAmount);
            ++index;
        } else {
            System.out.println("ERROR: BoveModeMTW.movetowardWaypoint(), unexpected case");
        }
        double targetDist = this.mRobotLocn.DistanceTo(this.mWaypoint.getDestination());
        if (targetDist < 10.0) {
            instructs[index] = BodyInstruction.valueOf(BodyInstruction.ENDED, 0.0);
        } else if (this.hasWaypointTimedOut()) {
            instructs[index] = BodyInstruction.valueOf(BodyInstruction.ENDED, 0.0);
        } else {
            double moveAmount = 25.0;
            if (moveAmount > targetDist) {
                moveAmount = targetDist;
            }
            instructs[index] = reversing ? BodyInstruction.valueOf(BodyInstruction.MOVE_BACK, moveAmount) : BodyInstruction.valueOf(BodyInstruction.MOVE_AHEAD, moveAmount);
        }
        return instructs;
    }

    private boolean hasWaypointTimedOut() {
        boolean answer = false;
        if (this.mTimeNow >= this.mWaypoint.getExpiryTime()) {
            answer = true;
        }
        return answer;
    }
}

