/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import shrub.GunController;
import shrub.Heading;
import shrub.Location;
import shrub.MHTracker;
import shrub.RadarInstruction;
import shrub.RadarModeAPI;
import shrub.RadarModeCSL;
import shrub.RadarModeNOP;
import shrub.RadarModeTOL;
import shrub.RobotDataStore;
import shrub.Sighting;

public class RadarMgr1v1
implements RadarModeAPI {
    private final RadarModeAPI mRadarModeNOP;
    private final RadarModeAPI mRadarModeCSL;
    private final RadarModeAPI mRadarModeTOL;
    private final MHTracker mTrackerRef;
    private final GunController mGunRef = GunController.getInstance();
    private final RobotDataStore mDataStore = RobotDataStore.getInstance();

    public RadarMgr1v1(MHTracker trackerRef) {
        this.mTrackerRef = trackerRef;
        this.mRadarModeNOP = new RadarModeNOP();
        this.mRadarModeCSL = new RadarModeCSL(45.0);
        this.mRadarModeTOL = new RadarModeTOL(45.0, 15.0);
    }

    public RadarInstruction GenerateInstruction() {
        int numFreshTargets = this.mTrackerRef.GetNumFreshTargets();
        boolean haveLockOn = this.mTrackerRef.HasLockOn();
        long numOthers = this.mDataStore.getNumOthers();
        Location radarLocn = this.mDataStore.getMyLocn();
        Heading radarHdng = this.mDataStore.getMyRadarHdng();
        long currentTime = this.mDataStore.getCurrentTime();
        RadarModeAPI radarModeInUse = this.mRadarModeNOP;
        if (!haveLockOn) {
            radarModeInUse = this.mRadarModeCSL;
        } else {
            Sighting currentTarget = this.mTrackerRef.GetCurrentTarget();
            Location tgtLocn = currentTarget.GetLocation();
            ((RadarModeTOL)this.mRadarModeTOL).SetTargetLocn(tgtLocn);
            radarModeInUse = this.mRadarModeTOL;
        }
        RadarInstruction radarInstruct = radarModeInUse.GenerateInstruction();
        return radarInstruct;
    }

    public void Resynchronise() {
        this.mRadarModeNOP.Resynchronise();
        this.mRadarModeCSL.Resynchronise();
        this.mRadarModeTOL.Resynchronise();
    }
}

