/*
 * Decompiled with CFR 0.152.
 */
package pedersen.core;

import pedersen.core.Snapshot;
import pedersen.core.SnapshotHistory;
import pedersen.debug.Debug;
import pedersen.physics.Projection;
import pedersen.physics.StaticHeading;
import pedersen.physics.StaticPosition;
import pedersen.physics.StaticVector;
import pedersen.physics.StaticVectorImpl;
import pedersen.physics.StaticVelocity;

public abstract class SnapshotHistoryBase
implements SnapshotHistory {
    private Snapshot snapshot = null;
    private final Snapshot[] hotScan = new Snapshot[22];
    private StaticPosition projectedPosition = null;
    private long timeOfLastStop;

    public void appendSnapshot(Snapshot newSnapshot) {
        if (Math.abs(newSnapshot.getVelocity()) <= 1.0) {
            this.timeOfLastStop = newSnapshot.getTime();
        }
        if (this.snapshot == null) {
            newSnapshot.setVectorDelta(new StaticVectorImpl(0.0, 0.0));
            newSnapshot.setEnergyDelta(0.0);
            newSnapshot.setLinearMeanTargetingPosition(this.hotScan[21]);
            newSnapshot.setHeadingDeltaRollingAverage(0.0);
            newSnapshot.setVelocityRollingAverage(newSnapshot.getVelocity());
            newSnapshot.setElapsedTimeSinceLastStop(0L);
        } else {
            newSnapshot.setVectorDelta(this.snapshot.compareVector(newSnapshot));
            newSnapshot.setEnergyDelta(newSnapshot.getEnergy() - this.snapshot.getEnergy());
            newSnapshot.setLinearMeanTargetingPosition(this.hotScan[21]);
            newSnapshot.setHeadingDeltaRollingAverage(SnapshotHistoryBase.rollingAverage(this.snapshot.getHeadingDeltaRollingAverage(), newSnapshot.getHeadingDelta()));
            newSnapshot.setVelocityRollingAverage(SnapshotHistoryBase.rollingAverage(this.snapshot.getVelocityRollingAverage(), newSnapshot.getVelocity()));
            newSnapshot.setElapsedTimeSinceLastStop(newSnapshot.getTime() - this.timeOfLastStop);
        }
        this.snapshot = newSnapshot;
        this.projectedPosition = newSnapshot;
        int i = 21;
        while (i > 0) {
            this.hotScan[i] = this.hotScan[i - 1];
            --i;
        }
        this.hotScan[0] = newSnapshot;
    }

    public void projectPosition() {
        Projection projection = new Projection(this);
        projection.setRelativeTargetHeading(this.getHeadingDelta());
        projection.setRelativeTargetVelocity(this.getVelocityDelta());
        this.projectedPosition = projection.project().getStaticPosition();
    }

    static double rollingAverage(double value, double newEntry) {
        return (value * 30.0 + newEntry * 1.0) / 31.0;
    }

    public void debug() {
        Debug.debug("Snapshot History:");
        Debug.debug("no debug information defined");
    }

    public Snapshot getHotScan(int index) {
        return this.hotScan[index];
    }

    public long getRound() {
        return this.snapshot.getRound();
    }

    public long getTime() {
        return this.snapshot.getTime();
    }

    public void setVectorDelta(StaticVector newDelta) {
        this.snapshot.setVectorDelta(newDelta);
    }

    public StaticVector getVectorDelta() {
        return this.snapshot.getVectorDelta();
    }

    public double getHeadingDelta() {
        return this.snapshot.getHeadingDelta();
    }

    public double getVelocityDelta() {
        return this.snapshot.getVelocityDelta();
    }

    public double getEnergy() {
        return this.snapshot.getEnergy();
    }

    public void setEnergyDelta(double newDelta) {
        this.snapshot.setEnergyDelta(newDelta);
    }

    public double getEnergyDelta() {
        return this.snapshot.getEnergyDelta();
    }

    public void setLinearMeanTargetingPosition(StaticPosition staticPosition) {
        this.snapshot.setLinearMeanTargetingPosition(staticPosition);
    }

    public StaticPosition getLinearMeanTargetingPosition() {
        return this.snapshot.getLinearMeanTargetingPosition();
    }

    public void setHeadingDeltaRollingAverage(double rollingAverage) {
        this.snapshot.setHeadingDeltaRollingAverage(rollingAverage);
    }

    public double getHeadingDeltaRollingAverage() {
        return this.snapshot.getHeadingDeltaRollingAverage();
    }

    public void setVelocityRollingAverage(double rollingAverage) {
        this.snapshot.setVelocityRollingAverage(rollingAverage);
    }

    public double getVelocityRollingAverage() {
        return this.snapshot.getVelocityRollingAverage();
    }

    public void setElapsedTimeSinceLastStop(long elapsedTime) {
        this.snapshot.setElapsedTimeSinceLastStop(elapsedTime);
    }

    public long getElapsedTimeSinceLastStop() {
        return this.snapshot.getElapsedTimeSinceLastStop();
    }

    public double getX() {
        return this.projectedPosition.getX();
    }

    public double getY() {
        return this.projectedPosition.getY();
    }

    public boolean equalsPosition(StaticPosition other) {
        return this.projectedPosition.equalsPosition(other);
    }

    public StaticPosition getRelativePosition(StaticPosition other) {
        return this.projectedPosition.getRelativePosition(other);
    }

    public StaticVector getRelativeVector(StaticPosition other) {
        return this.projectedPosition.getRelativeVector(other);
    }

    public double getBearing(StaticPosition other) {
        return this.projectedPosition.getBearing(other);
    }

    public double getDistance(StaticPosition other) {
        return this.projectedPosition.getDistance(other);
    }

    public double getHeading() {
        return this.snapshot.getHeading();
    }

    public boolean equalsAngle(double other) {
        return this.snapshot.equalsAngle(other);
    }

    public boolean equalsAngle(StaticHeading other) {
        return this.snapshot.equalsAngle(other);
    }

    public double getRelativeAngle(double other) {
        return this.snapshot.getRelativeAngle(other);
    }

    public double getRelativeAngle(StaticHeading other) {
        return this.snapshot.getRelativeAngle(other);
    }

    public double getCompoundAngle(double other) {
        return this.snapshot.getCompoundAngle(other);
    }

    public double getCompoundAngle(StaticHeading other) {
        return this.snapshot.getCompoundAngle(other);
    }

    public double getVelocity() {
        return this.snapshot.getVelocity();
    }

    public boolean equalsVelocity(double other) {
        return this.snapshot.equalsVelocity(other);
    }

    public boolean equalsVelocity(StaticVelocity other) {
        return this.snapshot.equalsVelocity(other);
    }

    public double getRelativeVelocity(double other) {
        return this.snapshot.getRelativeVelocity(other);
    }

    public double getRelativeVelocity(StaticVelocity other) {
        return this.snapshot.getRelativeVelocity(other);
    }

    public double getCompoundVelocity(double other) {
        return this.snapshot.getCompoundVelocity(other);
    }

    public double getCompoundVelocity(StaticVelocity other) {
        return this.snapshot.getCompoundVelocity(other);
    }

    public boolean equalsVector(StaticVector other) {
        return this.snapshot.equalsVector(other);
    }

    public StaticVector compareVector(StaticVector other) {
        return this.snapshot.compareVector(other);
    }
}

