/*
 * Decompiled with CFR 0.152.
 */
package pedersen.physics;

import pedersen.core.Constraints;
import pedersen.debug.Debug;
import pedersen.physics.DynamicVelocity;
import pedersen.physics.StaticVelocity;
import pedersen.physics.StaticVelocityImpl;

public class DynamicVelocityImpl
implements DynamicVelocity {
    private StaticVelocity velocity;
    private StaticVelocity target;

    public DynamicVelocityImpl(double newVelocity) {
        this.setVelocity(newVelocity);
        this.setAbsoluteTargetVelocity(newVelocity);
    }

    public DynamicVelocityImpl(StaticVelocity newVelocity) {
        this.setVelocity(newVelocity);
        this.setAbsoluteTargetVelocity(newVelocity);
    }

    public StaticVelocity getStaticVelocity() {
        return this.velocity;
    }

    public void setVelocity(double newVelocity) {
        this.velocity = new StaticVelocityImpl(newVelocity);
    }

    public void setVelocity(StaticVelocity newVelocity) {
        this.velocity = new StaticVelocityImpl(newVelocity);
    }

    public void setAbsoluteTargetVelocity(double newVelocity) {
        this.target = new StaticVelocityImpl(newVelocity);
    }

    public void setAbsoluteTargetVelocity(StaticVelocity newVelocity) {
        this.target = new StaticVelocityImpl(newVelocity);
    }

    public void setRelativeTargetVelocity(double other) {
        this.setAbsoluteTargetVelocity(this.velocity.getCompoundVelocity(other));
    }

    public void setRelativeTargetVelocity(StaticVelocity other) {
        this.setAbsoluteTargetVelocity(this.velocity.getCompoundVelocity(other));
    }

    public double projectVelocity(double maximumVelocity) {
        double relativeVelocity = DynamicVelocityImpl.getDeltaVelocity(this.velocity.getVelocity(), this.target.getVelocity());
        double absoluteVelocity = this.velocity.getCompoundVelocity(relativeVelocity);
        return Constraints.getClosestLegalValue(-maximumVelocity, absoluteVelocity, maximumVelocity);
    }

    private static double getDeltaVelocity(double v0, double v1) {
        double deltaVelocity = Constraints.isInRange(0.0, v0, v1) || Constraints.isInRange(v1, v0, 0.0) ? Constraints.getClosestLegalVehicularAcceleration(v1 - v0) : Constraints.getClosestLegalVehicularDeceleration(v1 - v0);
        return deltaVelocity;
    }

    public void debug() {
        Debug.debug("Dynamic velocity: " + this.getVelocity());
        Debug.debug("Target velocity: " + this.target.getVelocity());
    }

    public double getVelocity() {
        return this.velocity.getVelocity();
    }

    public boolean equalsVelocity(double other) {
        return this.velocity.equalsVelocity(other);
    }

    public boolean equalsVelocity(StaticVelocity other) {
        return this.velocity.equalsVelocity(other);
    }

    public double getRelativeVelocity(double other) {
        return this.velocity.getRelativeVelocity(other);
    }

    public double getRelativeVelocity(StaticVelocity other) {
        return this.velocity.getRelativeVelocity(other);
    }

    public double getCompoundVelocity(double other) {
        return this.velocity.getCompoundVelocity(other);
    }

    public double getCompoundVelocity(StaticVelocity other) {
        return this.velocity.getCompoundVelocity(other);
    }
}

