/*
 * Decompiled with CFR 0.152.
 */
package pedersen.tactics.grail;

import pedersen.core.Constraints;
import pedersen.core.Snapshot;
import pedersen.divination.WaveData;
import pedersen.misc.Arena;
import pedersen.physics.StaticPosition;
import pedersen.tactics.grail.Segment;
import pedersen.tactics.grail.SegmentLateralVelocityImpl;
import pedersen.tactics.grail.SegmentTimeToImpactWallImpl;
import pedersen.tactics.targeting.TargetingMethod;
import pedersen.tactics.targeting.TargetingMethodBase;

public class WaveAnalysis {
    private Segment literal = new SegmentTimeToImpactWallImpl();
    private Segment virtual = new SegmentTimeToImpactWallImpl();

    public double generateRandomBearingOffset() {
        return (Math.random() * 2.0 - 1.0) * Constraints.maxEscapeAngle;
    }

    public long getHitCountByIndex(int index) {
        return this.literal.getHitCountByIndex(index);
    }

    public void recordWave(WaveData waveData) {
        if (waveData.isLiveRound()) {
            this.literal.addWaveData(waveData);
        }
        this.virtual.addWaveData(waveData);
    }

    public double getMostVisitedFiringAngle(WaveData waveData, boolean isVirtual) {
        return isVirtual ? this.virtual.getMostVisitedBearingOffset(waveData) : this.literal.getMostVisitedBearingOffset(waveData);
    }

    public double getLeastVisitedFiringAngle(WaveData waveData) {
        return this.literal.getLeastVisitedBearingOffset(waveData);
    }

    public double getMostVisitedLinearProjection(WaveData waveData) {
        return this.literal.getMostVisitedLinearProjection(waveData);
    }

    public TargetingMethod getFavoredTargetingMethod(WaveData waveData) {
        double successRateVirtual;
        double successRateLiteral;
        TargetingMethod favoredTargetingMethod = null;
        TargetingMethod favoredTargetingMethodLiteral = this.literal.getFavoredTargetingMethod(waveData);
        TargetingMethod favoredTargetingMethodVirtual = this.virtual.getFavoredTargetingMethod(waveData);
        favoredTargetingMethod = favoredTargetingMethodLiteral != null && favoredTargetingMethodVirtual != null ? ((successRateLiteral = favoredTargetingMethodLiteral.getTargetingStatistics().getSuccessRate()) > (successRateVirtual = favoredTargetingMethodVirtual.getTargetingStatistics().getSuccessRate()) ? favoredTargetingMethodLiteral : favoredTargetingMethodVirtual) : (favoredTargetingMethodLiteral != null ? favoredTargetingMethodLiteral : favoredTargetingMethodVirtual);
        return favoredTargetingMethod;
    }

    public WaveData getWaveData(StaticPosition firingPosition, Snapshot target, double bulletVelocity) {
        double distanceToTarget = firingPosition.getDistance(target);
        double bearingToTarget = firingPosition.getBearing(target);
        int timeToTarget = TargetingMethodBase.getBulletFlightTime(distanceToTarget, bulletVelocity);
        double distanceFromCenter = target.getDistance(Arena.getCenter());
        int timeToImpactWall = SegmentTimeToImpactWallImpl.calculateTimeToImpactWall(target);
        double acceleration = target.getVelocityDelta();
        double orbitalVelocity = SegmentLateralVelocityImpl.calculateOrbitalVelocity(bearingToTarget, target.getHeading(), target.getVelocity());
        long elapsedTimeSinceLastStop = target.getElapsedTimeSinceLastStop();
        return new WaveData(elapsedTimeSinceLastStop, distanceFromCenter, acceleration, timeToImpactWall, timeToTarget, orbitalVelocity, bearingToTarget);
    }

    public void debug() {
    }
}

