/*
 * Decompiled with CFR 0.152.
 */
package apvteam;

import apvteam.Bullet;
import apvteam.mambaGunOption;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;

public class MambaGun {
    private ArrayList virtualB = new ArrayList(1000);
    private mambaGunOption[][] stats = new mambaGunOption[5][67];
    public int n = 0;
    private double[] ev = new double[7500];
    private double[] eh = new double[7500];
    public double lastHeading;
    public double lastVel;
    public double avgAbsVel;
    public double lastEnergy;
    public double lastX;
    public double lastY;

    public void makeGunLearn(double now, double targetX, double targetY, double targetV, double targetH, double targetEnergy) {
        Iterator m = this.virtualB.iterator();
        while (m.hasNext()) {
            double hashit = 0.0;
            Bullet vBullet = (Bullet)m.next();
            if (vBullet.targetWasHit(targetX, targetY, now)) {
                this.stats[vBullet.distanceIndex][vBullet.guessIndex].rollingAvg(1.0);
                m.remove();
                continue;
            }
            if (!vBullet.outOfRange(targetX, targetY, now)) continue;
            this.stats[vBullet.distanceIndex][vBullet.guessIndex].rollingAvg(0.0);
            m.remove();
        }
        this.ev[this.n] = targetV;
        this.eh[this.n] = targetH - this.lastHeading;
        this.lastHeading = targetH;
        this.lastVel = targetV;
        this.avgAbsVel = this.avgAbsVel * 0.8 + 0.2 * Math.abs(this.lastVel);
        this.lastEnergy = targetEnergy;
        this.lastX = targetX;
        this.lastY = targetY;
        ++this.n;
        if (this.n > 7490) {
            this.n = 1000;
        }
    }

    public double getGunAiming(double x, double y) {
        double targetBearingAbs = Math.atan2(this.lastX - x, this.lastY - y);
        int index = this.index(Point2D.distance(x, y, this.lastX, this.lastY));
        int guessIndex = this.optionindex(index);
        int realguessIndex = guessIndex % 22;
        double power = this.stats[index][guessIndex].power;
        if (this.lastEnergy == 0.0) {
            return targetBearingAbs;
        }
        if (guessIndex < 66) {
            return ((double)realguessIndex - 10.0) / 10.0 * this.LinearShootAngle(targetBearingAbs, power) + targetBearingAbs;
        }
        return this.patternBasedPrediction(x, y, power);
    }

    public double getGunPower(double x, double y) {
        int index = this.index(Point2D.distance(x, y, this.lastX, this.lastY));
        int guessIndex = this.optionindex(index);
        return Math.min(Math.ceil(((double)guessIndex + 1.0) / 22.0), (double)3);
    }

    public void fireOrder(double time, double x, double y) {
        double gunoffset = 0.0;
        double targetBearingAbs = Math.atan2(this.lastX - x, this.lastY - y);
        int i = 0;
        while (i < 67) {
            int reali = i % 22;
            double guessFactor = ((double)reali - 10.0) / 10.0;
            gunoffset = guessFactor * this.LinearShootAngle(targetBearingAbs, 3) + targetBearingAbs;
            if (i == 66) {
                gunoffset = this.patternBasedPrediction(x, y, 3);
            }
            if (this.lastEnergy == 0.0) {
                gunoffset = 0.0;
            }
            this.virtualB.add(new Bullet(i, this.index(Point2D.distance(x, y, this.lastX, this.lastY)), x, y, gunoffset, time, Math.min(Math.ceil(((double)i + 1.0) / 22.0), (double)3)));
            ++i;
        }
    }

    public void newRound() {
        this.virtualB.clear();
    }

    private final int index(double value) {
        return (int)Math.min((double)4, Math.max(0.0, (value - 100.0) / 100.0));
    }

    private final int optionindex(int index) {
        int bi = 0;
        double bv = -10.0;
        int i = 0;
        while (i < 67) {
            double a = this.stats[index][i].value;
            double p = Math.min(Math.ceil(((double)i + 1.0) / 22.0), (double)3);
            double g = 10.0 * a * p - p - (double)2 * a;
            if (g > bv) {
                bi = i;
                bv = g;
            }
            ++i;
        }
        return bi;
    }

    private final double LinearShootAngle(double bearingabs, double power) {
        return Math.asin(this.avgAbsVel * (double)(this.lastVel >= 0.0 ? 1 : -1) / (20.0 - (double)3 * power) * Math.sin(this.lastHeading - bearingabs));
    }

    private final double patternBasedPrediction(double x, double y, double power) {
        int time = (int)(Point2D.distance(x, y, this.lastX, this.lastY) / (20.0 - (double)3 * power));
        int match = this.fitpattern(this.ev, this.n - 1, time);
        int matchb = this.fitpattern(this.eh, this.n - 1, time);
        double px = 0.0;
        double py = 0.0;
        int r = 0;
        while (r < 3) {
            px = this.lastX - x;
            py = this.lastY - y;
            double ah = this.lastHeading;
            int i = match + 1;
            while (i <= match + time) {
                px += Math.sin(ah) * this.ev[i];
                py += Math.cos(ah) * this.ev[i];
                ah += this.eh[i - match + matchb];
                ++i;
            }
            time = (int)(Math.sqrt(px * px + py * py) / (20.0 - (double)3 * power));
            ++r;
        }
        return Math.atan2(px, py);
    }

    private final int fitpattern(double[] e, int n, int time) {
        int match = 0;
        double low = 10000.0;
        int i = n - time;
        while (i >= Math.max(15, n - 999)) {
            double score = 0.0;
            int j = 14;
            while (j >= 0 && score <= low) {
                score = 0.25 * Math.pow(e[n - j] - e[i - j], 2) + 0.75 * score;
                --j;
            }
            if (score < low) {
                match = i;
                low = score;
            }
            --i;
        }
        return match;
    }

    public MambaGun() {
        int j = 0;
        while (j < 5) {
            int i = 0;
            while (i < 67) {
                this.stats[j][i] = new mambaGunOption();
                this.stats[j][i].index = i;
                this.stats[j][i].value = 0.23;
                this.stats[j][i].power = Math.ceil(((double)i + 1.0) / 22.0);
                ++i;
            }
            ++j;
        }
    }
}

