package gadsky;

import robocode.util.Utils;

import java.util.Random;


final class Tools {
	private static final Random random = new java.util.Random();

	public static double randDouble11() {
		return 2.0 * random.nextDouble() - 1.0;
	}

	public static double randDouble01() {
		return random.nextDouble();
	}

	public static int randInt(int min, int max) {
		int choices = max - min;
		return min + Math.abs(random.nextInt()) % choices;
	}

	public static boolean coin(int choices) {
		return randInt(0, choices) == 0;
	}


    public static double normalize(double angle) {
        return narrow(Math.PI / 2.0 - angle);
    }

    public static double narrow(double angle) {
        return Utils.normalRelativeAngle(angle);
    }

	public static double min3(double x1, double x2, double x3) {
		return Math.min(x1, Math.min(x2, x3));
	}

	public static double in(double value, double min, double max) {
		return Math.max(min, Math.min(max, value));
	}

}
