/*
 * Created on 07/12/2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package axeBots.data;

import java.util.ArrayList;

import axeBots.AxeBot;
import axeBots.AxeException;
import axeBots.util.RoboMath;

/**
 * @author Marcos
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class OptimizedBitBuffer {

    /**
     * 
     */
    private StringBuffer bitBuffer= new StringBuffer();
    private long size= 0;
    private long readIndex= 0;
    private int tail= 0;

    public OptimizedBitBuffer() {
        super();
        // TODO Auto-generated constructor stub
    }

    public void clear() {
        bitBuffer= new StringBuffer();
        size= 0;
        tail= 0;
    }

    public double getCoded(int bits, double divs, double min, double max)
        throws AxeException {
        //int bits= (int)Math.ceil(divs / 8.0);
        if ((bits > 32) || (bits == 0)) {
            throw new AxeException("parametro divs invalido!");
        }

        if ((min >= max)) {
            throw new AxeException("parametro min >= max");
        }

        double deslocamento0= 0 - min;

        double ret= this.get(bits);
//		AxeBot.getIt().out.println("ret:"+ret); 
        

        double delta= max - min;
        double x= delta / divs;

        ret= ret * x;

		ret -= deslocamento0;

        return ret;
    }

    public void addCoded(int bits, double val, double divs, double min, double max)
        throws AxeException {
        //int bits= (int)Math.ceil(divs / 8.0);
        if ((bits > 32) || (bits == 0)) {
            throw new AxeException("parametro divs invalido!");
        }

        if ((min >= max)) {
            throw new AxeException("parametro min >= max");
        }

        double desloc= 0 - min;

        val= (val < min) ? min : (val > max) ? max : val;

        double delta= max - min;
        double x= delta / divs;

		//AxeBot.getIt().out.print(" val:"+val);
		
        val= RoboMath.roundToPrecision(val, x);
		//AxeBot.getIt().out.print("x:"+x+">"+val);
        
        //val = (Math.round(val*100.00))/100.00;
        
		//AxeBot.getIt().out.print(">"+val+"d:"+desloc);

       val = val+desloc;
		//AxeBot.getIt().out.print(">"+val);
//		AxeBot.getIt().out.print(">>"+val); 
		

        char out= (char) Math.round(val / x);
		//AxeBot.getIt().out.print("/"+(val/x)); 
		//AxeBot.getIt().out.println(" out:"+(int)out); 
        add(out, bits);

    }

    public void add(char val, int bits) {

        //        if (bitBuffer.length() < 10) {
        //            AxeBot.getIt().out.println("adding:" + (int)val + "/" + bits);
        //        }

        int tam= (int)bits;
        int resto= (int) (size % 16);
        int mask= this.getMask(bits);

        //        if (bitBuffer.length() < 10) {
        //            AxeBot.getIt().out.println(
        //                "val hexa:" + (int)val + ":" + Integer.toBinaryString(val)+" resto:"+resto);
        //            AxeBot.getIt().out.println("mask:" + Integer.toBinaryString(mask));
        //        }

        val= (char) (val & mask);

        //		if (bitBuffer.length() < 10) {
        //					AxeBot.getIt().out.println(
        //						"val hexa:" + (int)val + ":" + Integer.toBinaryString(val)+" resto:"+resto);
        //					AxeBot.getIt().out.println("mask:" + Integer.toBinaryString(mask));
        //				}

        int intVal= ((int)val) << (16 + (16 - tam - resto));

        //		if (bitBuffer.length() < 10) {
        //					AxeBot.getIt().out.println(
        //						"val hexa:" + (int)val + ":" + Integer.toBinaryString(val)+" resto:"+resto);
        //					AxeBot.getIt().out.println("mask:" + Integer.toBinaryString(mask));
        //				}

        mask <<= (16 + (16 - tam - resto));

        //		if (bitBuffer.length() < 10) {
        //					AxeBot.getIt().out.println(
        //						"val hexa:" + (int)val + ":" + Integer.toBinaryString(val)+" resto:"+resto);
        //					AxeBot.getIt().out.println("mask:" + Integer.toBinaryString(mask));
        //				}

        //mask= (char) ~mask;

        //		if (bitBuffer.length() < 10) {
        //					AxeBot.getIt().out.println(
        //						"val hexa:" + (int)val + ":" + Integer.toBinaryString(val)+" resto:"+resto);
        //					AxeBot.getIt().out.println("mask:" + Integer.toBinaryString(mask));
        //				}

        //tail= (char) (tail & mask);
        tail |= intVal;

        //		if (bitBuffer.length() < 10) {
        //					AxeBot.getIt().out.println(
        //						"val hexa:" + (int)val + ":" + Integer.toBinaryString(val)+" resto:"+resto);
        //					AxeBot.getIt().out.println("mask:" + Integer.toBinaryString(mask));
        //				}

        //        if (bitBuffer.length() < 10) {
        //            AxeBot.getIt().out.println(
        //                "tail:"  + Integer.toBinaryString(tail));
        //        }

        size += bits;
        tam= (int) (size / 16);
        resto= (int) (size % 16);

        if (tam > bitBuffer.length()) {
            this.grow();
        }

        //        if (bitBuffer.length() < 10) {
        //            AxeBot.getIt().out.println(
        //                "tail:"+ Integer.toBinaryString(tail));
        //        }

    }

    public char get(int bits) {
        int pos= (int) (readIndex / 16);
        int resto= (int) (readIndex % 16);

        int ahd=
            ((pos + 1) >= bitBuffer.length()) ? 0 : bitBuffer.charAt(pos + 1);

        int zoom= (((int)bitBuffer.charAt(pos)) << 16) + ahd;

        int mask= this.getMask(bits);
        mask <<= (16 + (16 - resto - bits));
        int ret= zoom & mask;
        ret >>>= (16 + (16 - resto - bits));
        readIndex += bits;
        return (char)ret;
    }

    public void setBuffer(String buf) {
        bitBuffer= new StringBuffer(buf);
        size= bitBuffer.length();
        tail= 0;
    }

    public String getBuffer() {
        StringBuffer ret= new StringBuffer(bitBuffer.toString());
        ret.append((char) (tail >>> 16));
        return ret.toString();
    }

//    public static int countBits(int val) {
//        int mask= 1;
//        int ret= 0;
//        for (int i= 0; i < 32; i++) {
//            if ((val & mask) > 0) {
//                ret= i + 1;
//            }
//            val >>>= 1;
//        }
//        return ret;
//    }

    private int getMask(int bits) {
        int ret= (int) (Math.pow(2, bits) - 1);
        return ret;
    }

    private void grow() {
        char n= (char) (tail >>> 16);
        //        if (bitBuffer.length() < 10) {
        //            AxeBot.getIt().out.println(
        //                "growing tail:" + (int)tail + ":" + Integer.toBinaryString(tail));
        //			AxeBot.getIt().out.println(
        //							"growing char:" + (int)n + ":" + Integer.toBinaryString(n));
        //        }
        bitBuffer.append((char) (tail >>> 16));

        tail <<= 16;
    }

}
