package axeBots.okami;
import robocode.*;
import java.awt.geom.*;

import axeBots.gunner.AxeGunner;
//import java.lang.Math;
//import java.awt.geom.*; 
//import java.text.NumberFormat;
//import java.util.Vector;
//import java.io.PrintStream;   
//import java.io.*;

public class AxeShooter extends Condition {
	private AxeGunner gun;
    private AdvancedRobot myRobot;
    private double pwr;
    private long timeToHit;
    private AxeTarget target;
    private int aimStrat;
    private double targetDist;
    private Point2D.Double impactPt= null;
    private double facingAngle= 0;

    //
    public long getTimeToHit() {
        return timeToHit;
    }
    public AxeTarget getTarget() {
        return target;
    }
    public double getBulletPwr() {
        return pwr;
    }
    public int getAimStrat() {
        return aimStrat;
    }
    public double getTargetDist() {
        return targetDist;
    }
    public Point2D.Double getPoint() {
        return impactPt;
    }
    //public boolean  hitTarget()               { return hitTarget; }	
    public AxeShooter() {
        super();
    }

    public AxeShooter(
        AdvancedRobot ar,
        double pwr,
        long timeToHit,
        AxeTarget target,
        int aimStrat,
        double targetDist,
        double facing,
        double x,
        double y, AxeGunner gun) {
		this.setPriority(90);
        make(ar, pwr, timeToHit, target, aimStrat, targetDist, facing, x, y, gun);

    }

    public void start() {
        myRobot.addCustomEvent(this);
    }

    public void make(
        AdvancedRobot ar,
        double pwr,
        long timeToHit,
        AxeTarget target,
        int aimStrat,
        double targetDist,
        double facing,
        double x,
        double y,  AxeGunner gun) {

        this.myRobot= ar;
        this.pwr= pwr;
        this.timeToHit= timeToHit;
        this.aimStrat= aimStrat;
        this.target= target;
        this.targetDist= targetDist;
        this.impactPt= new Point2D.Double(x, y);
        this.setFacingAngle(facing);
        this.gun = gun;
        //myRobot.addCustomEvent(this);
//        ar.out.println("new AxeShooter!");

    }

    public boolean test() {
//myRobot.out.println("testing:"+myRobot.getGunTurnRemaining());
        if (myRobot.getGunTurnRemaining() == 0) //leste
            {

            myRobot.removeCustomEvent(this);
            return true;
        }
        return false;
    }
    /**
     * @return
     */
    public double getFacingAngle() {
        return facingAngle;
    }

    /**
     * @param d
     */
    public void setFacingAngle(double d) {
        facingAngle= d;
    }

    /**
     * @return
     */
    public AxeGunner getGun() {
        return gun;
    }

}
