/**
 *	Use to control TimmiT Radar turn.
 */

package timmit;

class Radar{
	private static TimmiT bot;
	private static Enemy en;
	private static int Losetime = 4;			//currentTime - lastScannedEnemyTime.
	private static int Radardirect = 2;			//radar turn left and turn right range.
	
	Radar(TimmiT owner){
		this.bot = owner;
	}//end construct
	
	protected void do_radar(Enemy en){
		this.en = en;
		if(bot.getTime() - en.scannedTime > Losetime || bot.getOthers()>1){			//have not scanned enemy in 4 times.
			this.turnAround();
		}else{
			this.lockScanned();
		}//end if
	}//end
	
	private void turnAround(){
		bot.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);		//turn radar around the battlefield.
	}//end
	
	private void lockScanned(){							//radar locked the enemy.
		bot.setTurnRadarRightRadians(Util.getRelativeRadians(en.absoluteBearingRadians - bot.getRadarHeadingRadians()) * Radardirect);
	}//end
}