package lucasslf.utility;

import java.awt.geom.Point2D;

public class Utils {

	// By Paul Evans
	// value = old value
	// newEntry = value to be averaged
	// n= old value weighting
	// weighting = new value weighting
	public static double rollingAvg(double value, double newEntry, double n,
			double weighting) {
		return (value * n + newEntry * weighting) / (n + weighting);
	}

	
	
	public static double getMaxTurningInOneTick(double velocity){
		return Math.PI / 720d
		* (40d - 3d * Math.abs(velocity));
	}
	
	public static double angleFromPoints(Point2D angleVertex, Point2D a, Point2D b) {
		double sideA = angleVertex.distance(b);
		double sideB = angleVertex.distance(a);
		double sideC = a.distance(b);
		double vertexCos = (sideA*sideA + sideB*sideB - sideC*sideC) /( 2 * sideA * sideB);
		return Math.acos(vertexCos);
	}
	public static double toRadians(double degress) {
		return degress /180 *Math.PI;
	}
	
	public static double toDegrees(double radians) {
		return radians * 180 / Math.PI;
	}
	
	//Taken from lots of other robots *********
	public static double absoluteBearing(Point2D source, Point2D target) {
		return Math.atan2(target.getX() - source.getX(),
				target.getY() - source.getY());
	}

	public static double limit(double min, double value, double max) {
		return Math.max(min, Math.min(value, max));
	}

	//By PEZ
	public static Point2D project(Point2D sourceLocation, double angle,
			double length) {
		return new Point2D.Double(sourceLocation.getX() + Math.sin(angle)
				* length, sourceLocation.getY() + Math.cos(angle) * length);
	}

	public static double bulletVelocity(double power) {
		return 20 - power * 3;
	}	

	//****************
	

}
