package sgp;
import robocode.*;
import java.util.*;

/**
 * PatternIntercept - a class by Simon Parker
 */

public class PatternIntercept extends LinearIntercept implements java.io.Serializable
{
	PatternAnalyser analyser;

	public boolean isPredictionReliable = true;

	public PatternIntercept(PatternAnalyser patternAnalyser)
	{
		analyser = patternAnalyser;
	}

	protected Coordinate getEstimatedPosition(double time)
	{
		Coordinate relativeNormalisedPosition = analyser.getEstimatedDeltaPosition(targetVelocity, time);
		Coordinate relativeAbsolutePosition = relativeNormalisedPosition.rotate(targetHeading);
		return Strategy.limitToBattleField(targetStartingPoint.plus(relativeAbsolutePosition));
	}


	public void calculate
		(
			double xb,
			double yb,
			double xt,
			double yt,
			double tHeading,
			double vt,
			double bPower,
			double angularVelocity_deg_per_sec
		)
	{
		super.calculate(xb, yb, xt, yt, tHeading, vt, bPower, angularVelocity_deg_per_sec);
		Coordinate coordinate = getEstimatedPosition(impactTime);
		double error = analyser.futurePositionArray.getError(vt, impactTime);
		isPredictionReliable = (error < (2 * targetRadius));

	}
}