package bayen.nut;
import robocode.*;
import davidalves.sample.DrawingBot;
import java.util.*;
import robocode.util.*;
import java.awt.geom.*;
import java.awt.*;
import java.io.*;
import java.lang.*;         // for Double and Integer objects
import java.util.ArrayList; // for collection of waves

/**
 * FleetFeet - Squirrel's movement
 */
public class FleetFeet
{
	AdvancedRobot Squirrel;
	double dir = 1;
	ScannedRobotEvent lastScan;
	double iD = 600;
	int corner = 1;
	int adval = 1;
	static double eShots = 0;
	static double eHits = 0;
	static boolean circle = true;
	static boolean waveSurf = false;
	static boolean flatten = false;
	static boolean change = true;
	static boolean getCloser = false;
	static int enemyShots = 0;
	int hitsThisRound = 0;
	static double weightn = 4;
	
	static final boolean notFlattening = false;
	
	public static final double ALMOST_HALF_PI = 1.25;
	
	public static final double WAY_OVER_HALF_PI = 2.45;
	
	public static final double OVER_HALF_PI = 1.75;
	
	public static int BINS = 47;
	public static int AVOID_BIN = 23;
    public static double _surfStats[] = new double[BINS]; // we'll use 47 bins
    public Point2D.Double _myLocation;     // our bot's location
    public Point2D.Double _enemyLocation;  // enemy bot's location

    public ArrayList _enemyWaves;
    public ArrayList _surfDirections;
    public ArrayList _surfAbsBearings;

    // We must keep track of the enemy's energy level to detect EnergyDrop,
    // indicating a bullet is fired
    public static double _oppEnergy = 100.0;

    // This is a rectangle that represents an 800x600 battle field,
    // used for a simple, iterative WallSmoothing method (by Kawigi).
    // If you're not familiar with WallSmoothing, the wall stick indicates
    // the amount of space we try to always have on either end of the tank
    // (extending straight out the front or back) before touching a wall.
    public static Rectangle2D.Double _fieldRect
        = new java.awt.geom.Rectangle2D.Double(18, 18, 764, 564);
    public static double WALL_STICK = 160;
	
	public FleetFeet(AdvancedRobot robot) {
		Squirrel = robot;
		renderables = new Vector();
		if(circle)
		System.out.println("CIRCLING ENABLED");
		if(!waveSurf && !circle)
		System.out.println("BUZZING ENABLED");
		if(waveSurf && flatten)
		System.out.println("SURFING ENABLED");
		_enemyWaves = new ArrayList();
        _surfDirections = new ArrayList();
        _surfAbsBearings = new ArrayList();
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		if(enemyShots / (Squirrel.getRoundNum()+1) <= 1 && (Squirrel.getRoundNum()+1 == 1?(Squirrel.getTime()>500):true))
		iD = 100;
		else
		iD = 600;
		//System.out.println(e.getDistance());
		//System.out.println("Time: " + Squirrel.getTime());
		_myLocation = new Point2D.Double(Squirrel.getX(), Squirrel.getY());

        double lateralVelocity = Squirrel.getVelocity()*Math.sin(e.getBearingRadians());
        double absBearing = e.getBearingRadians() + Squirrel.getHeadingRadians();

        //setTurnRadarRightRadians(Utils.normalRelativeAngle(absBearing - Squirrel.getRadarHeadingRadians()) * 2);

        _surfDirections.add(0,
            new Integer((lateralVelocity >= 0) ? 1 : -1));
        _surfAbsBearings.add(0, new Double(absBearing + Math.PI));


        double bulletPower = _oppEnergy - e.getEnergy();
        if ((bulletPower < 3.01 && bulletPower > 0.09
            && _surfDirections.size() > 2) || (circle && Squirrel.getTime() > 30)) {
            EnemyWave ew = new EnemyWave();
            ew.fireTime = Squirrel.getTime() - 1;
            ew.bulletVelocity = bulletVelocity(bulletPower);
            ew.distanceTraveled = bulletVelocity(bulletPower);
            ew.direction = ((Integer)_surfDirections.get(2)).intValue();
            ew.directAngle = ((Double)_surfAbsBearings.get(2)).doubleValue();
            ew.fireLocation = (Point2D.Double)_enemyLocation.clone(); // last tick
			eShots++;
            _enemyWaves.add(ew);
			enemyShots++;
        }

        _oppEnergy = e.getEnergy();

        // update after EnemyWave detection, because that needs the previous
        // enemy location as the source of the wave
        _enemyLocation = project(_myLocation, absBearing, e.getDistance());

        updateWaves();
		if(Squirrel.getTime()<30)
		lastScan = e;
		if(Squirrel.getOthers()==1){
			if(!waveSurf && !circle){
		double dif = lastScan.getEnergy() - e.getEnergy();
		if(dif<=3 && dif>0){
		    if(!waveSurf && !circle){
			dir=-dir;
			
			//eShots++;
			}/*
			if(dif==3)
			iD=225;
			else if(dif>=2)
			iD=300;
			else if(dif>=1)
			iD=340;
			else if(dif>=0)
			iD=iD;*/
	    }
		double goAngle = Math.toRadians(normalRelativeAngle(
		e.getBearing()+90*dir-(e.getDistance()>(iD+100)?45:20)*dir*
		(e.getDistance()<(iD)?-1:1)) + Squirrel.getHeading());
		goAngle = wallSmoothing(_myLocation, goAngle, (int)-dir);
		//if(nearWall())
		//dir=-dir;
		if(!waveSurf && !circle)
		//Squirrel.setAhead(100*dir);
		//if(waveSurf || circle)
		//if(Squirrel.getDistanceRemaining() == 0) {
			//dir = -dir;
			//Squirrel.setAhead(200 * Math.random() * dir);
		//}
		lastScan = e;
		setBackAsFront(Squirrel, goAngle);
	}
		else {
			if(Squirrel.getOthers() ==1)
			Squirrel.setMaxVelocity(8);
			doSurfing();
		}
		}
		if(Squirrel.getOthers() > 1){
			if(Math.random() < .1)
			Squirrel.setMaxVelocity(4.0 + Math.random() * 8.0);
			if(Squirrel.getDistanceRemaining() == 0){
				
				//corner++;
				adval *= -1;
				if(corner>4)
				corner = 1;
				if(corner == 1)
			    goTo(new Point2D.Double(100 - 50 * adval,100 + 50 * adval));
			    if(corner == 2)
			    goTo(new Point2D.Double(100 + 50 * adval,
			Squirrel.getBattleFieldHeight()
			-100 + 50 * adval));
			    if(corner == 3)
			    goTo(new Point2D.Double
			(Squirrel.getBattleFieldWidth()
			- 100 + 50 * adval,
			              Squirrel.getBattleFieldHeight() -100 - 50 * adval));
		    	if(corner == 4)
			    goTo(new Point2D.Double(
			Squirrel.getBattleFieldWidth()
			- 100 + 50 * adval,100 + 50 * adval));}
		}
		/*
		if(Squirrel.getOthers() > 1){
			if(Squirrel.getDistanceRemaining() == 0){
				corner++;
				if(corner==5)
				corner = 1;
				if(corner == 1)
			    goTo(new Point2D.Double(100,100));
			    if(corner == 2)
			    goTo(new Point2D.Double(100,
			Squirrel.getBattleFieldHeight()
			-100));
			    if(corner == 3)
			    goTo(new Point2D.Double
			(Squirrel.getBattleFieldWidth()
			- 100,
			              Squirrel.getBattleFieldHeight() -100));
		    	if(corner == 4)
			    goTo(new Point2D.Double(
			Squirrel.getBattleFieldWidth()
			- 100,100));
		    }
		}*/
	}
	
	public void onHitWall(HitWallEvent e) {
		dir=-dir;
	}
	public void onHitRobot(HitRobotEvent e) {
		dir=-dir;
		corner++;
	}
	public boolean nearWall() {
		if(dir==-1){
		    if(Squirrel.getX() + 100 >= 
		Squirrel.getBattleFieldWidth() &&
		Squirrel.getHeading() > 270 - 90 && 
		Squirrel.getHeading() < 270 + 90)
		    return true;
		    if(Squirrel.getX() - 100 <= 0 && 
		Squirrel.getHeading() > 0 &&
		Squirrel.getHeading() < 180)
		    return true;
		    if(Squirrel.getY() + 100 >=
		Squirrel.getBattleFieldHeight() &&
		Squirrel.getHeading() > 180 - 90 &&
		Squirrel.getHeading() < 180 + 90)
		    return true;
		    if(Squirrel.getY() - 100 <= 0 &&
		Squirrel.getHeading() > 360 - 90 &&
		Squirrel.getHeading() < 90)
		    return true;
	    }
	else{
		if(Squirrel.getX() + 100 >=
		Squirrel.getBattleFieldWidth()
		&& Squirrel.getHeading() > 0 &&
		Squirrel.getHeading() < 180)
		return true;
		if(Squirrel.getX() - 100 <= 0 &&
		Squirrel.getHeading() > 270 - 90
		&& Squirrel.getHeading() < 270 + 90)
		return true;
		if(Squirrel.getY() + 100 >=
		Squirrel.getBattleFieldHeight()
		&& Squirrel.getHeading() > 360 - 90 &&
		Squirrel.getHeading() < 90)
		return true;
		if(Squirrel.getY() - 100 <= 0 &&
		Squirrel.getHeading() > 180 - 90
		&& Squirrel.getHeading() < 180 + 90)
		return true;
	}
		return false;
	}
	private void goTo(Point2D destination) {
        Point2D location = new Point2D.Double(
           Squirrel.getX(), Squirrel.getY());
        double distance = location.distance(destination);
        double angle = normalRelativeAngle(absoluteBearing(
                       location, destination) -
                       Squirrel.getHeading());
        if (Math.abs(angle) > 90) {
            distance *= -1;
            if (angle > 0) {
                angle -= 180;
            }
            else {
                angle += 180;
            }
        }
        Squirrel.setTurnRight(angle);
        Squirrel.setAhead(distance);
    }
	private double absoluteBearing(Point2D source, Point2D target) {
        return Math.toDegrees(Math.atan2(target.getX()
               - source.getX(), target.getY() - source.getY()));
    }
	private double normalRelativeAngle(double angle) {
        angle = Math.toRadians(angle);
        return Math.toDegrees(Math.atan2(
               Math.sin(angle), Math.cos(angle))); 
    }
	 public void updateWaves() {
        for (int x = 0; x < _enemyWaves.size(); x++) {
            EnemyWave ew = (EnemyWave)_enemyWaves.get(x);

            ew.distanceTraveled = (Squirrel.getTime() - ew.fireTime) * ew.bulletVelocity;
            drawCircle(ew.fireLocation, ew.distanceTraveled, Color.red);
			if (ew.distanceTraveled >
                _myLocation.distance(ew.fireLocation) + 50) {
				Point2D.Double myLocation = new Point2D.Double(
                Squirrel.getX(), Squirrel.getY());
				if(flatten && !notFlattening)
				logFlatness(ew, myLocation);
                _enemyWaves.remove(x);
                x--;
            }
        }
    }

    public EnemyWave getClosestSurfableWave() {
        double closestDistance = 50000; // I just use some very big number here
        EnemyWave surfWave = null;

        for (int x = 0; x < _enemyWaves.size(); x++) {
            EnemyWave ew = (EnemyWave)_enemyWaves.get(x);
            double distance = _myLocation.distance(ew.fireLocation)
                - ew.distanceTraveled;

            if (distance > ew.bulletVelocity && distance < closestDistance) {
                surfWave = ew;
                closestDistance = distance;
            }
        }

        return surfWave;
    }

    // Given the EnemyWave that the bullet was on, and the point where we
    // were hit, calculate the index into our stat array for that factor.
    public static int getFactorIndex(EnemyWave ew, Point2D.Double targetLocation) {
        double offsetAngle = (absoluteBearing(ew.fireLocation, targetLocation)
            - ew.directAngle);
        double factor = Utils.normalRelativeAngle(offsetAngle)
            / maxEscapeAngle(ew.bulletVelocity) * ew.direction;

        return (int)limit(0,
            (factor * ((BINS - 1) / 2)) + ((BINS - 1) / 2),
            BINS - 1);
    }

    // Given the EnemyWave that the bullet was on, and the point where we
    // were hit, update our stat array to reflect the danger in that area.
    public void logHit(EnemyWave ew, Point2D.Double targetLocation) {
        int index = getFactorIndex(ew, targetLocation);
		AVOID_BIN = index;
        for (int x = 0; x < BINS; x++) {
            // for the spot bin that we were hit on, add 1;
            // for the bins next to it, add 1 / 2;
            // the next one, add 1 / 5; and so on...
            //_surfStats[x] += 1.0 / (Math.pow(index - x, 2) + 1);
			_surfStats[x] = rollingAverage(_surfStats[x], 1.0 / (Math.pow(index - x, 2) + 1), weightn);
        }
    }
public void logFlatness(EnemyWave ew, Point2D.Double targetLocation) {
        int index = getFactorIndex(ew, targetLocation);

        for (int x = 0; x < BINS; x++) {
            // for the spot bin that we were hit on, add 1;
            // for the bins next to it, add 1 / 2;
            // the next one, add 1 / 5; and so on...
            //_surfStats[x] += 0.5 / (Math.pow(index - x, 2) + 1);
			_surfStats[x] = rollingAverage(_surfStats[x], 1.0 / (Math.pow(index - x, 2) + 1), weightn * 3);
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
	//System.out.println("HitByBullet: " + Squirrel.getTime());
	/*if(!waveSurf){
		eHits++;
		
		if(eHits/eShots > .3) {
			if(Squirrel.getRoundNum() > 1 ||
			   Squirrel.getTime() > 600){
			   waveSurf = true;
				}
		}}*/
        // If the _enemyWaves collection is empty, we must have missed the
        // detection of this wave somehow.
eHits++;
        if (!_enemyWaves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(
                e.getBullet().getX(), e.getBullet().getY());
            EnemyWave hitWave = null;

            // look through the EnemyWaves, and find one that could've hit us.
            for (int x = 0; x < _enemyWaves.size(); x++) {
                EnemyWave ew = (EnemyWave)_enemyWaves.get(x);

                if (Math.abs(ew.distanceTraveled -
                    _myLocation.distance(ew.fireLocation)) < 50
                    && Math.round(bulletVelocity(e.getBullet().getPower()) * 10)
                       == Math.round(ew.bulletVelocity * 10)) {
                    hitWave = ew;
                    break;
                }
            }
if (hitWave != null && change) {
			if(_myLocation.distance(hitWave.fireLocation) > 90
			&& (
			!(getFactorIndex(hitWave, hitBulletLocation) <= 20
					&&getFactorIndex(hitWave, hitBulletLocation) >= 25
					&&circle)
					
					|| (
					!(getFactorIndex(hitWave, hitBulletLocation) <= 42
					&&getFactorIndex(hitWave, hitBulletLocation) >= 47
					&&!waveSurf && !circle)
					)
					|| (waveSurf && flatten)
					)
					)
		hitsThisRound++;
		if(circle){
			if((hitsThisRound > Squirrel.getRoundNum())){
				hitsThisRound = 0;
				circle = false;
			}
		}
		if(!waveSurf && !circle){
			if((hitsThisRound > Squirrel.getRoundNum())){
				hitsThisRound = 0;
				waveSurf = true;
				flatten = true;
			}
		}}
            if (hitWave != null) {
				if(!circle && waveSurf)
                logHit(hitWave, hitBulletLocation);
				
                // We can remove this wave now, of course.
                _enemyWaves.remove(_enemyWaves.lastIndexOf(hitWave));
            }
        }
    }

    // CREDIT: mini sized predictor from Apollon, by rozu
    // http://robowiki.net?Apollon
    public Point2D.Double predictPosition(EnemyWave surfWave, int direction) {
    	Point2D.Double predictedPosition = (Point2D.Double)_myLocation.clone();
    	double predictedVelocity = Squirrel.getVelocity();
    	double predictedHeading = Squirrel.getHeadingRadians();
    	double maxTurning, moveAngle, moveDir;

        int counter = 0; // number of ticks in the future
        boolean intercepted = false;

    	do {
    		moveAngle =
                wallSmoothing(predictedPosition, absoluteBearing(surfWave.fireLocation,
                predictedPosition) + (direction * (Math.PI/2)), direction)
                - predictedHeading;
    		moveDir = 1;

    		if(Math.cos(moveAngle) < 0) {
    			moveAngle += Math.PI;
    			moveDir = -1;
    		}

    		moveAngle = Utils.normalRelativeAngle(moveAngle);

    		// maxTurning is built in like this, you can't turn more then this in one tick
    		maxTurning = Math.PI/720d*(40d - 3d*Math.abs(predictedVelocity));
    		predictedHeading = Utils.normalRelativeAngle(predictedHeading
                + limit(-maxTurning, moveAngle, maxTurning));

    		// this one is nice ;). if predictedVelocity and moveDir have
            // different signs you want to breack down
    		// otherwise you want to accelerate (look at the factor "2")
    		predictedVelocity += (predictedVelocity * moveDir < 0 ? 2*moveDir : moveDir);
    		predictedVelocity = limit(-8, predictedVelocity, 8);

    		// calculate the new predicted position
    		predictedPosition = project(predictedPosition, predictedHeading, predictedVelocity);

            counter++;

            if (predictedPosition.distance(surfWave.fireLocation) <
                surfWave.distanceTraveled + (counter * surfWave.bulletVelocity)
                + surfWave.bulletVelocity) {
                intercepted = true;
            }
    	} while(!intercepted && counter < 500);

    	return predictedPosition;
    }

    public double checkDanger(EnemyWave surfWave, int direction) {
        int index = getFactorIndex(surfWave,
            predictPosition(surfWave, direction));
		double returnVal = _surfStats[index];
		if(flatten) {
		if(index == AVOID_BIN)
		returnVal = 100;
		if(index == AVOID_BIN + 1 || index == AVOID_BIN - 1)
		returnVal = 99;
		if(index == AVOID_BIN + 2 || index == AVOID_BIN - 2)
		returnVal = 98;
		if(index == AVOID_BIN + 3 || index == AVOID_BIN - 3)
		returnVal = 97;
		if(index == AVOID_BIN + 4 || index == AVOID_BIN - 4)
		returnVal = 96;}
        return returnVal;
    }

    public void doSurfing() {
        EnemyWave surfWave = getClosestSurfableWave();

        if (surfWave == null) { return; }

        double dangerLeft = checkDanger(surfWave, -1);
        double dangerRight = checkDanger(surfWave, 1);
		double RIGHTL = (lastScan.getDistance() > iD?(lastScan.getDistance() > iD + 100?Math.toRadians(45):Math.toRadians(20)):Math.toRadians(-20));

        double goAngle = absoluteBearing(surfWave.fireLocation, _myLocation);
        if (dangerLeft < dangerRight) {
            goAngle = wallSmoothing(_myLocation, goAngle - (Math.PI/2 + RIGHTL), -1);
        } else {
            goAngle = wallSmoothing(_myLocation, goAngle + (Math.PI/2 + RIGHTL), 1);
        }

        setBackAsFront(Squirrel, goAngle);
    }

    // This can be defined as an inner class if you want.
    class EnemyWave {
        Point2D.Double fireLocation;
        long fireTime;
        double bulletVelocity, directAngle, distanceTraveled;
        int direction;

        public EnemyWave() { }
    }

    // CREDIT: Iterative WallSmoothing by Kawigi
    //   - return absolute angle to move at after account for WallSmoothing
    // robowiki.net?WallSmoothing
    public double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        while (!_fieldRect.contains(project(botLocation, angle, 160))) {
            angle += orientation*0.05;
        }
        return angle;
    }

    // CREDIT: from CassiusClay, by PEZ
    //   - returns point length away from sourceLocation, at angle
    // robowiki.net?CassiusClay
    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length,
            sourceLocation.y + Math.cos(angle) * length);
    }

    // got this from RaikoMicro, by Jamougha, but I think it's used by many authors
    //  - returns the absolute angle (in radians) from source to target points
    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double bulletVelocity(double power) {
        return (20D - (3D*power));
    }

    public static double maxEscapeAngle(double velocity) {
        return Math.asin(8.0/velocity);
    }

    public static void setBackAsFront(AdvancedRobot robot, double goAngle) {
        double angle =
            Utils.normalRelativeAngle(goAngle - robot.getHeadingRadians());
        if (Math.abs(angle) > (Math.PI/2)) {
            if (angle < 0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            robot.setBack(100);
        } else {
            if (angle < 0) {
                robot.setTurnLeftRadians(-1*angle);
           } else {
                robot.setTurnRightRadians(angle);
           }
            robot.setAhead(100);
        }
    }	
	public double rollingAverage(double oldVal, double newVal, double weight) {
		//if(newVal == 0) System.out.println("LOWERED:");
		//else System.out.println("HIGHTENED:");
		//System.out.println("OLD: " + oldVal);
		//System.out.println("NEW: " + ((weight - 1.0) * oldVal + newVal) / weight);
		return ((weight - 1.0) * oldVal + newVal) / weight;
	}
private static abstract class Renderable{
	public abstract void render(Graphics2D g);
	
	private static class Circle extends Renderable{
		Point2D.Double center;
		double radius;
		Color color;
		public Circle(Point2D.Double center, double radius, Color color){
			this.center = center;
			this.radius = radius;
			this.color = color;
		}
		public void render(Graphics2D g) {
			g.setColor(color);
			g.drawOval(	(int)Math.round(center.x - radius),
						(int)Math.round(center.y - radius),
						(int)Math.round(2 * radius),
						(int)Math.round(2 * radius));
		}
	}
	
	private static class Dot extends Renderable{
		Point2D.Double point;
		double radius;
		Color color;
		public Dot(Point2D.Double point, Color color){
			this.point = point;
			this.radius = 2;
			this.color = color;
		}
		public void render(Graphics2D g) {
			g.setColor(color);
			g.fillOval(	(int)Math.round(point.x - radius),
						(int)Math.round(point.y - radius),
						(int)Math.round(2 * radius),
						(int)Math.round(2 * radius));
		}
	}
	
	private static class Line extends Renderable{
		Point2D.Double p1, p2;
		Color color;
		
		double radius;
		public Line(Point2D.Double p1, Point2D.Double p2, Color color){
			this.p1 = p1;
			this.p2 = p2;
			this.color = color;
		}
		public void render(Graphics2D g) {
			g.setColor(color);
			g.drawLine(	(int)Math.round(p1.x),
						(int)Math.round(p1.y),
						(int)Math.round(p2.x),
						(int)Math.round(p2.y));
		}
	}
	
	private static class Text extends Renderable{
		String text;
		double x, y;
		Color color;
		
		double radius;
		public Text(String text, double x, double y, Color color){
			this.text = text;
			this.x = x;
			this.y = y;
			this.color = color;
		}
		public void render(Graphics2D g) {
			g.setColor(color);
			g.drawString(text, (float)x, (float)y);
		}
	}
	}
	
	
	
	public static Vector renderables;
	
	
	public void onPaint(Graphics2D g){
		Iterator i = renderables.iterator();
		while(i.hasNext()){
			Renderable r = (Renderable) i.next();
			r.render(g);
		}
		renderables.clear();
	}
	
	public static void drawLine(Point2D.Double p1, Point2D.Double p2, Color color){
		renderables.add(new Renderable.Line(p1, p2, color));
	}
	
	public static void drawCircle(Point2D.Double center, double radius, Color color){
		renderables.add(new Renderable.Circle(center, radius, color));
	}
	
	public static void drawPoint(Point2D.Double p1, Color color){
		renderables.add(new Renderable.Dot(p1, color));
	}
	
	public static void drawText(String text, double x, double y, Color color){
		renderables.add(new Renderable.Text(text, x, y, color));
	}
}
					