package djc;

import djc.gun.*;
import djc.util.*;

import java.awt.*;
import java.awt.geom.*;
import java.util.*;

import robocode.*;
import robocode.util.*;

/**
 * For deciding which BaseGun to use
 */
public class GunManager
{
	/****************************************************************************
	 *                              Constants                                   *
	 ****************************************************************************/
	
	public static AbstractDynaBot myrobot = null;
	public ArrayList myWaves;
	public int currentGunIndex = 2;
	protected BaseGun []gunList;
	protected static int []wavesSent;      // GameStages
	
	public GunManager(AbstractDynaBot themyrobot) {
		myrobot = themyrobot;
		gunList = new BaseGun[DynaBotConstants.NUMGUNS];
		gunList[DynaBotConstants.HEADONGUN] = new BaseGun(myrobot);
		gunList[DynaBotConstants.LINEARGUN] = new LinearGun(myrobot);
		gunList[DynaBotConstants.CIRCULARGUN] = new CircularGun(myrobot);
		gunList[DynaBotConstants.FUNKYCHICKENGUN] = new FunkyChickenGun(myrobot);
		gunList[DynaBotConstants.GUESSFACTORGUN] = new BasicGuessFactorGun(myrobot);
		gunList[DynaBotConstants.ANGULARGUN] = new AngularGun(myrobot);
		gunList[DynaBotConstants.BEEGUN] = new BeeGun(myrobot);
						
		currentGunIndex = DynaBotConstants.ANGULARGUN;
		
		wavesSent = new int[DynaBotConstants.GAMESTAGES];
		myWaves = new ArrayList();
	}

	public BaseGun currentGun() {
		return gunList[currentGunIndex];
	}
	
	/**
	 * what to do before each battle
	 */
	public void reset() {
		myWaves = new ArrayList();
		switchToFitestExcludingID(-1);
	}

	/**
	 * what to do each tick
	 */
	public void doWork() {
		gunList[currentGunIndex].doWork();
		int gameStage = MyUtils.getGameStage(myrobot.getOthers());
		if(wavesSent[gameStage]++ < DynaBotConstants.MINIMUM_WAVES_PER_STAGE) {
			if((int)myrobot.getTime() % DynaBotConstants.NONFIRING_WAVE_RATE == 0) {
				createMyWaves(DynaBotConstants.MAX_SHOT_ENERGY);
			}
		}
	}

	/**
	 * Switches currentGunIndex to the gun with the best fitness
	 */
	public void switchToFitestExcludingID(int excludeID) {
		double bestFitness = Double.NEGATIVE_INFINITY;
		int newGun = 0;
		for(int i=DynaBotConstants.NUMGUNS-1;i>=0;i--) {
			if(i != excludeID) {
				double curFitness = gunList[i].gunFitness();
				//myrobot.out.println("Fitness: " + curFitness + " Best: " + bestFitness + " for " + gunList[i].name);
				if(curFitness > bestFitness) {
					bestFitness = curFitness;
					// TODO - Stop testing individual guns...
					//myrobot.out.println("Best Fitness: " + bestFitness + " for gun " + i);
					newGun = i;
					//newGun = DynaBotConstants.HEADONGUN;
					//newGun = DynaBotConstants.LINEARGUN;
					//newGun = DynaBotConstants.CIRCULARGUN;
					//newGun = DynaBotConstants.FUNKYCHICKENGUN;
					//newGun = DynaBotConstants.GUESSFACTORGUN;
					//newGun = DynaBotConstants.ANGULARGUN;					
					if(myrobot.getOthers() == 1) {
						newGun = DynaBotConstants.BEEGUN;
					}
				}
			}
		}
		
		//if(newGun != currentGunIndex) {
			currentGunIndex = newGun;
			//myrobot.out.println("Switching gun to " + gunList[newGun].name);
		//}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		gunList[currentGunIndex].onScannedRobot(e);		
	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {
	}
	
	public void onBulletHit(BulletHitEvent e) {
	}

	public void onBulletHitBullet(BulletHitBulletEvent e) {
	}

	public void onBulletMissed(BulletMissedEvent e) {
	}

	public void onDeath(DeathEvent e) {
		printStats();
	}

	public void onHitRobot(HitRobotEvent e) {
	}

	public void onPaint(Graphics2D g) {
		gunList[currentGunIndex].onPaint(g);
	}

	public void onRobotDeath(RobotDeathEvent e) {
	}

	public void onWin(WinEvent e) {
		printStats();
	}
	
	public void printStats() {
	}
	
	/**
	 * A lot happens when we fire.
	 */
	public void doFireGun(double shotPower) {
		createMyWaves(shotPower);
		// Add a virtual bullet for each guntype
		createVirtualBullets(shotPower);
	}

	protected void createMyWaves(double shotPower) {
		if(myrobot.theMoveManager.surfDirections.size() > 2) {
			EnemyWave ew = new EnemyWave(false);  // Set the .htDirectAngles rather than .directAngle
			ew.fireTime = myrobot.getTime() - 1;
			ew.bulletVelocity = MyUtils.getShotVelocity(shotPower);
			ew.distanceTraveled = ew.bulletVelocity;
			ew.direction = ((Integer)myrobot.theMoveManager.surfDirections.get(2)).intValue();
			//ew.directAngle = ((Double)myrobot.theMoveManager.surfAbsBearings.get(2)).doubleValue();
			Enumeration en = myrobot.theEnemyManager.enemyList.elements();
			while(en.hasMoreElements()) {
				Enemy e = (Enemy)en.nextElement();
				Double dblAbsBearing = new Double(e.absBearing);
				ew.directAngles.put(e.name, dblAbsBearing);
				Double dblLastDist = new Double(e.lastDistance);
				ew.lastDistances.put(e.name, dblLastDist);
				Double dblPrevVel = new Double(e.prevLinVelocity);
				ew.prevVelocity.put(e.name, dblPrevVel);
				Double dblCurVel = new Double(e.linVelocity);
				ew.curVelocity.put(e.name, dblCurVel);
			}
			ew.fireLocation = myrobot.location;
			
			myWaves.add(ew);
			
			int gameStage = MyUtils.getGameStage(myrobot.getOthers());
			// Increment our count:
			wavesSent[gameStage]++;
		}
	}

	/********************************************************************************
	 *                        For Virtual Gun Tracking                              *
	 *******************************************************************************/
	// Create virtual bullets for each enemy by each gun
	protected void createVirtualBullets(double shotPower) {
		Enumeration en = myrobot.theEnemyManager.enemyList.elements();
		Point2D.Double shotFrom = new Point2D.Double(myrobot.location.getX(), myrobot.location.getY());
			
		while(en.hasMoreElements()) {
			Enemy e = (Enemy)en.nextElement();
			String enemyName = e.name;
			double shotDistance = e.lastDistance;
		
			for(int i=0;i<DynaBotConstants.NUMGUNS;i++) {
				double fireAngle = gunList[i].calcGunTurnRadians(e);
				VirtualBullet vb = new VirtualBullet(enemyName, i, shotDistance, shotFrom, shotPower, fireAngle, (int)myrobot.getTime()-1);
				myrobot.theBattleManager.virtualBulletsFired.add(vb);
			}
			myrobot.theEnemyManager.fireVirtualShots(enemyName, shotDistance);
		}
	}
}
