package djc;

import djc.radar.*;
import djc.util.*;

import java.awt.*;
import robocode.*;

/**
 * Decides which BaseRadar to use
 */
public class RadarManager
{
	/****************************************************************************
	 *                              Constants                                   *
	 ****************************************************************************/
	public static final int NUMRADARS               = 4;
	public static final int BASE_RADAR              = 0;
	public static final int RADAR_LOCK_DUEL         = 1;
	public static final int THEARTOFWAR_RADAR       = 2;
	public static final int INTELLIGENT_MELEE_RADAR = 3;		
	
	public static AbstractDynaBot myrobot = null;
	protected int currentRadarIndex = 0;
	protected BaseRadar []radarList;
		
	public RadarManager(AbstractDynaBot themyrobot) {
		myrobot = themyrobot;
	}

	/**
	 * what to do before each battle
	 */
	public void reset() {
		radarList = new BaseRadar[NUMRADARS];
		
		radarList[BASE_RADAR]              = new BaseRadar(myrobot);
		radarList[RADAR_LOCK_DUEL]         = new LockRadar(myrobot);
		radarList[THEARTOFWAR_RADAR]       = new TheArtOfWarRadar(myrobot);
		radarList[INTELLIGENT_MELEE_RADAR] = new IntelligentMeleeRadar(myrobot);
		
		switchToBestRadar();
	}

	/**
	 * what to do each tick
	 */
	public void doWork() {
		radarList[currentRadarIndex].doWork();
	}

	public BaseRadar getCurrentRadar() {
		return radarList[currentRadarIndex];
	}

	public void switchToBestRadar() {
		if(myrobot.getOthers() == 1 ) {
			currentRadarIndex = RADAR_LOCK_DUEL;
		} else {
			//currentRadarIndex = INTELLIGENT_MELEE_RADAR;
			currentRadarIndex = THEARTOFWAR_RADAR;
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		radarList[currentRadarIndex].onScannedRobot(e);
	}

	public void onPaint(Graphics2D g) {
	}

	public void onRobotDeath(RobotDeathEvent e) {
		switchToBestRadar();
		radarList[currentRadarIndex].onRobotDeath(e);
	}

	public void onWin(WinEvent e) {
	}

	public void onHitRobot(HitRobotEvent e) {
	}

	public void onHitWall(HitWallEvent e) {
	}

}
