package tjk.offense;

import tjk.universe.Universe;
import tjk.universe.Bot;
import tjk.utils.FastTrig;
import robocode.util.Utils;
import java.awt.geom.Point2D;

/**
 * CircularGun - a class by RoboWiki
 * 
 *   Code available at http://robowiki.net/wiki/Circular_Targeting
 */
public class CircularGun
{
	
	private Universe universe = null;
	
	private Bot enemy = null;
	
	private Bot me = null;
	
	public CircularGun(Universe u)
	{
		universe = u;
		enemy = universe.getEnemy();
		me = universe.getMe();
	}
	
	
	// Report absolute fire angle.
	public double shoot(double bulletPower)
	{
		
		double myX = me.getX();
		double myY = me.getY();
		double absoluteBearing = me.headingToEnemy();
		double dist = me.getLocation().distance(enemy.getLocation());
		double enemyX = myX + dist * FastTrig.sin(absoluteBearing);
		double enemyY = myY + dist * FastTrig.cos(absoluteBearing);
		double enemyHeading = enemy.getHeading();
		double oldEnemyHeading = enemy.getMeOneAgo().getHeading();
		double enemyHeadingChange = Utils.normalRelativeAngle(enemyHeading - oldEnemyHeading);
		double enemyVelocity = enemy.getV();
		oldEnemyHeading = enemyHeading;
	 
		double deltaTime = 0;
		double battleFieldHeight = Universe.bfH();
  		double battleFieldWidth = Universe.bfW();
		double predictedX = enemyX, predictedY = enemyY;
		
		while((++deltaTime) * (20.0 - 3.0 * bulletPower) < Point2D.Double.distance(myX, myY, predictedX, predictedY))
		{		
			predictedX += FastTrig.sin(enemyHeading) * enemyVelocity;
			predictedY += FastTrig.cos(enemyHeading) * enemyVelocity;
			enemyHeading += enemyHeadingChange;
			if(	predictedX < 18.0 
			|| predictedY < 18.0
			|| predictedX > battleFieldWidth - 18.0
			|| predictedY > battleFieldHeight - 18.0)
			{
			
				predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);	
				predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
				break;
			}
		}

		double theta = Utils.normalAbsoluteAngle(FastTrig.atan2(predictedX - myX, predictedY - myY));
 		return theta;
	}
	
}
