package romz.component.movement.center;

import static romz.math.RobotMath.distance;
import static romz.math.RobotMath.heading;
import romz.component.movement.Movement;
import romz.model.Situation;
import romz.model.advice.MovementAdvice;

public class GoToCenterMovement implements Movement {

	private boolean started = false;
	
	@Override
	public MovementAdvice getMovementAdvice(Situation situation) {
		MovementAdvice movementAdvice = new MovementAdvice();
		movementAdvice.heading = heading(situation.hero.x, situation.hero.y, situation.battleField.width / 2, situation.battleField.height / 2);
		if (!started && (situation.hero.heading - movementAdvice.heading) < 1) {
			started = true;
			movementAdvice.direction = 1;
			movementAdvice.distance = distance(situation.hero.x, situation.hero.y, situation.battleField.width / 2, situation.battleField.height / 2);
		}
		return movementAdvice;
	}

}
