package PkKillers;

import robocode.*;
import robocode.util.Utils;
import java.awt.geom.Point2D;

public class PkAssassin extends AdvancedRobot {

	public Point2D.Double enemyLoc;

	public final static int MAX_DISTANCE = 1000;
	public final static int DISTANCE_INDEXES = MAX_DISTANCE / 100;

	public final static int VELOCITY_INDEXES = 5;

	public final static int BINS = 37;
	public final static int MIDDLE_BIN = (BINS - 1) / 2;
	public final static double MAX_ESC_ANGLE = Math.PI / 4.0;
	public final static double BIN_WIDTH = MAX_ESC_ANGLE / MIDDLE_BIN;
	private byte moveDirection = 1;
	private int tooCloseToWall = 0;
	private int wallMargin = 60;

	public static int[][][] aimFactors = new int[DISTANCE_INDEXES][VELOCITY_INDEXES][BINS];

	public void run() {
		addCustomEvent(new Condition("too_close_to_walls") {
				public boolean test() {
					return (
						// we're too close to the left wall
						(getX() <= wallMargin ||
						 // or we're too close to the right wall
						 getX() >= getBattleFieldWidth() - wallMargin ||
						 // or we're too close to the bottom wall
						 getY() <= wallMargin ||
						 // or we're too close to the top wall
						 getY() >= getBattleFieldHeight() - wallMargin)
						);
					}
				});

		while (true) {
			turnRadarRightRadians(Double.POSITIVE_INFINITY);
		}
	}
	public void onCustomEvent(CustomEvent e) {
		if (e.getCondition().getName().equals("too_close_to_walls"))
		{
			if (tooCloseToWall <= 0) {
				tooCloseToWall += wallMargin;
				setMaxVelocity(0);
			}
		}
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		setTurnRight(e.getBearing()+90);
		
		double absBearing = getHeadingRadians() + e.getBearingRadians();
		double firePower = e.getDistance() < 200 ? 3 : 1.72;
		BulletWave w = new BulletWave();
		w.firedLocation = new Point2D.Double(getX(), getY());
		enemyLoc = new Point2D.Double(getX() + Math.sin(absBearing) * e.getDistance(), getY()
				+ Math.cos(absBearing) * e.getDistance());
		w.bearingDir = (e.getVelocity() * Math.sin(e.getHeadingRadians() - absBearing) < 0 ? -BIN_WIDTH
				: BIN_WIDTH);
		w.bearing = absBearing;
		w.velocity = bulletVelocity(firePower);
		int distanceIndex = (int) e.getDistance() / (MAX_DISTANCE / DISTANCE_INDEXES);
		int velocityIndex = (int) Math.abs(e.getVelocity() / 2);
		w.aimFactors = aimFactors[distanceIndex][velocityIndex];
		int mostVisited = MIDDLE_BIN;
		for (int i = 0; i < BINS; i++)
			if (w.aimFactors[i] > w.aimFactors[mostVisited])
				mostVisited = i;
		setTurnGunRightRadians(Utils.normalRelativeAngle(absBearing - getGunHeadingRadians()
				+ w.bearingDir * (mostVisited - MIDDLE_BIN)));
		if (setFireBullet(firePower) != null)
			addCustomEvent(w);
		setTurnRadarRightRadians(Utils.normalRelativeAngle(absBearing - getRadarHeadingRadians()) * 2);
		
		if (tooCloseToWall > 0) tooCloseToWall--;

		// switch directions if we've stopped
		// (also handles moving away from the wall if too close)
		if (getVelocity() == 0) {
			setMaxVelocity(8);
			moveDirection *= -1;
		}
		
		long n = getTime();
		setAhead(moveDirection*Math.sin(n/13)*Math.cos(n/11)*200);
		execute();
	}

	double absoluteBearing(Point2D.Double p, Point2D.Double q) {
		return Math.atan2(q.x - p.x, q.y - p.y);
	}

	double bulletVelocity(double power) {
		return 20 - 3 * power;
	}

	public class BulletWave extends Condition {
		int[] aimFactors;
		Point2D.Double firedLocation;
		double velocity, distanceTraveled, bearing, bearingDir;

		public boolean test() {
			distanceTraveled += velocity;
			double distance = firedLocation.distance(enemyLoc);
			if (distanceTraveled > distance - 18) {
				try {
					aimFactors[(int) ((Utils
							.normalRelativeAngle(absoluteBearing(firedLocation, enemyLoc)) - bearing) / bearingDir)
							+ MIDDLE_BIN]++;
				} catch (Exception e) {
				}
				removeCustomEvent(this);
			}
			return false;
		}
	}
}