package bvh.hdr;

import java.awt.geom.*;
/**
 * Utils
 *
 * Algemene hulpfuncties (overgenomen uit forums op de RobocodeRepository website)
 */
class RoboUtils implements Constanten {

/**
* if a bearing is not within the -pi to pi range, alters it to provide the shortest angle.
*/
   public static double normaliseerRichting(double ang)
   {
      return ( ang + ( 7 * PI ) ) % TWEEPI - PI;
   }

/**
* bepaal richting van bot tot doel-positie
*/
   public static double bepaalRichting(double Xd, double Yd, double Xb, double Yb ) 
   {
      return Math.atan2( (Xd - Xb), (Yd - Yb) );
   }
   public static double bepaalRichting(Point2D.Double doel, Point2D.Double oorsprong) 
   {
      return Math.atan2( (doel.x-oorsprong.x), (doel.y-oorsprong.y) );
   }

   public static Point2D.Double projecteerPositie(Point2D.Double pos, double richting, double afstand){
      return new Point2D.Double( pos.x + afstand * Math.sin(richting)
                               , pos.y + afstand * Math.cos(richting)
                               );
   }

/**
* bepaal teken van een waarde
*/
   public static double sign(double a) 
   {
       return (a/Math.abs(a));
   }
   public static int sign(int a) 
   {
       return (a/Math.abs(a));
   }

/**
* functie geeft rechthoek met afgeronde hoeken:
*/

    public static RoundRectangle2D rectangle(double width, double height, double margin) {
        return new RoundRectangle2D.Double( margin
                                          , margin
                                          , width - margin * 2
                                          , height - margin * 2, 75, 75
                                          );
   }
    
   public static RoundRectangle2D slagveld(double breedte, double hoogte) {
      return new RoundRectangle2D.Double( WANDAFSTAND
                                        , WANDAFSTAND
                                        , breedte - WANDAFSTAND * 2D
                                        , hoogte  - WANDAFSTAND * 2D
                                        , RONDING
                                        , RONDING
                                        );
   }

} // einde Utils
