package kawigi.sbf;
import java.awt.geom.*;
/**
 * MiniBullet - like OffensiveVirtualBullet, but smaller code.  Now even supports variable-speed bullets!
 */
public class MiniBullet
{
	double startx, starty, startgunheading, direction, lastx, lasty, bulletspeed;
	long firetime, lasttime;
	int latspeed, dindex, wallrel, accl;
	
	public int updateEnemy(double x, double y, long time)
	{
		//I just linearly interpolate where they've been if I don't get an update each tick.  Should be a
		//reasonable interpolation, at least relative to firing angle, as long as I don't often go several turns
		//without a scan.
		long dtime;
		double dx = (x-lastx)/(dtime = time-lasttime);
		double dy = (y-lasty)/dtime;
		do
		{
			if (Point2D.distance(lastx, lasty, startx, starty) <= bulletspeed*(lasttime-firetime))  	//could have hit now.
				//now returns the index into my stat buffer instead of the normalized angle (which is figured out on a different max constant, btw).
				return (int)Math.round((1+robocode.util.Utils.normalRelativeAngle(Math.atan2(lastx-startx, lasty-starty)-startgunheading)/direction)*15);
			lasttime++;
			lastx+=dx;
			lasty+=dy;
		}
		while (lasttime < time);
		return -1;
	}
}
