/*
 * Decompiled with CFR 0.152.
 */
package taqho;

import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import taqho.Bearing;
import taqho.GameInfo;
import taqho.Heading;
import taqho.Location;
import taqho.Logger;
import taqho.MathUtils;

public class RobotData {
    protected String name;
    protected int numScans;
    protected double energy;
    protected double energyDelta;
    boolean isAlive;
    protected Location location;
    protected Location locationRelative;
    protected Bearing bearingToMe;
    protected Bearing bearingAbsolute;
    protected Heading myHeading;
    protected double headingDelta;
    protected double headingDeltaMovingAverage;
    protected double distance;
    protected double velocity;
    protected double velocityAverage;
    protected double velocityMovingAverage;
    protected double velocitySum;
    protected double velocityDelta;
    protected double speed;
    protected double speedAverage;
    protected double speedMovingAverage;
    protected double speedSum;
    protected double timeUpdated;
    protected double timeUpdatedDelta;
    protected int antiGravRepulsion;
    static final int TM_DIRECT = 1;
    static final int TM_LINEAR = 2;
    static final int TM_AVG_VEL = 3;
    static final int TM_CIRCULAR = 4;
    protected int targettingMethod;
    protected int targettingMethodLast;

    public RobotData(String theName) {
        this.initialise();
        this.name = theName;
    }

    public RobotData(ScannedRobotEvent e) {
        this.initialise();
        this.name = e.getName();
        this.onScannedRobotEvent(e);
    }

    protected void initialise() {
        this.isAlive = true;
        this.numScans = 0;
        this.energyDelta = 0.0;
        this.energy = 0.0;
        this.location = new Location();
        this.locationRelative = new Location();
        this.bearingToMe = new Bearing();
        this.bearingAbsolute = new Bearing();
        this.myHeading = new Heading();
        this.headingDeltaMovingAverage = 0.0;
        this.headingDelta = 0.0;
        this.timeUpdatedDelta = 0.0;
        this.timeUpdated = 0.0;
        this.velocityDelta = 0.0;
        this.velocitySum = 0.0;
        this.velocityMovingAverage = 0.0;
        this.velocityAverage = 0.0;
        this.velocity = 0.0;
        this.speedSum = 0.0;
        this.speedMovingAverage = 0.0;
        this.speedAverage = 0.0;
        this.speed = 0.0;
        this.targettingMethodLast = -1;
        this.targettingMethod = -1;
        this.antiGravRepulsion = -50;
    }

    public void onScannedRobotEvent(ScannedRobotEvent e) {
        if ((double)e.getTime() != this.timeUpdated) {
            AdvancedRobot robot = GameInfo.getRobot();
            ++this.numScans;
            this.timeUpdatedDelta = (double)e.getTime() - this.timeUpdated;
            this.timeUpdated = e.getTime();
            this.velocityDelta = (e.getVelocity() - this.velocity) / this.timeUpdatedDelta;
            this.velocity = e.getVelocity();
            this.velocitySum += this.velocity;
            this.velocityAverage = this.velocitySum / (double)this.numScans;
            this.velocityMovingAverage = 0.99 * this.velocityMovingAverage + 0.01 * this.velocity;
            this.speed = Math.abs(this.velocity);
            this.speedSum += this.speed;
            this.speedAverage = this.speedSum / (double)this.numScans;
            this.speedMovingAverage = 0.99 * this.speedMovingAverage + 0.01 * this.speed;
            this.distance = e.getDistance();
            this.energyDelta = e.getEnergy() - this.energy;
            this.energy = e.getEnergy();
            this.isAlive = true;
            this.headingDelta = MathUtils.normaliseBearingDegrees(e.getHeading() - this.myHeading.Get()) / this.timeUpdatedDelta;
            this.headingDeltaMovingAverage = 0.7 * this.headingDeltaMovingAverage + 0.3 * this.headingDelta;
            this.myHeading.Set(e.getHeading());
            this.bearingToMe.Set(e.getBearing());
            this.bearingAbsolute.Set(this.bearingToMe.Get() + robot.getHeading());
            double bearingA = this.bearingAbsolute.Get();
            this.locationRelative.SetX(MathUtils.sin(bearingA) * this.distance);
            this.locationRelative.SetY(MathUtils.cos(bearingA) * this.distance);
            this.location.SetRelative(robot.getX(), robot.getY(), this.bearingAbsolute.convertToHeading(), this.distance);
        }
    }

    public double getTimeUpdated() {
        return this.timeUpdated;
    }

    public Location getLocation() {
        return this.location;
    }

    public Heading getMyHeading() {
        return this.myHeading;
    }

    public Bearing getBearingToMe() {
        return this.bearingToMe;
    }

    public double getBearingToMeVal() {
        return this.bearingToMe.Get();
    }

    public double getX() {
        return this.location.GetX();
    }

    public double getY() {
        return this.location.GetY();
    }

    public String getName() {
        return this.name;
    }

    public int getAntiGravRepulsion() {
        return this.antiGravRepulsion;
    }

    public void setTargettingMethod(int method) {
        if (method != this.targettingMethod) {
            this.targettingMethodLast = this.targettingMethod;
            this.targettingMethod = method;
            switch (method) {
                case 1: {
                    Logger.log("RD: Targetting: DIRECT");
                    break;
                }
                case 2: {
                    Logger.log("RD: Targetting: LINEAR");
                    break;
                }
                case 3: {
                    Logger.log("RD: Targetting: AVG VEL");
                    break;
                }
                case 4: {
                    Logger.log("RD: Targetting: CIRCULAR");
                    break;
                }
                default: {
                    Logger.log("RD: Targetting: UNKNOWN");
                }
            }
        }
    }

    public double getBearingToShootAt(double bulletVelocity) {
        double offset = 0.0;
        if (this.name == "Crazy") {
            offset = this.getBearingOffsetForTargettingMovingAvgVelocity(bulletVelocity);
            return this.bearingAbsolute.Get() + offset;
        }
        offset = this.speed == 0.0 ? (Math.random() < 0.8 ? this.getBearingOffsetForTargettingDirect(bulletVelocity) : this.getBearingOffsetForTargettingMovingAvgVelocity(bulletVelocity)) : (this.headingDelta == 0.0 ? this.getBearingOffsetForTargettingLinear(bulletVelocity) : this.getBearingOffsetForTargettingCircular(bulletVelocity));
        return this.bearingAbsolute.Get() + offset;
    }

    public double getBearingOffsetForTargettingDirect(double bulletVelocity) {
        this.setTargettingMethod(1);
        return 0.0;
    }

    public double getBearingOffsetForTargettingLinear(double bulletVelocity) {
        this.setTargettingMethod(2);
        return this.getBearingOffsetForTargettingLinearWithVelocity(bulletVelocity, this.velocity);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public double getBearingOffsetForTargettingLinearWithVelocity(double bulletVelocity, double targetVelocity) {
        double predictedY;
        double predictedX;
        double myY;
        double myX;
        block3: {
            double d;
            double battleFieldWidth;
            double battleFieldHeight;
            double deltaTime;
            block2: {
                AdvancedRobot robot = GameInfo.getRobot();
                deltaTime = 0.0;
                myX = robot.getX();
                myY = robot.getY();
                battleFieldHeight = robot.getBattleFieldHeight();
                battleFieldWidth = robot.getBattleFieldWidth();
                predictedX = this.location.GetX();
                predictedY = this.location.GetY();
                if (!true) break block2;
                d = deltaTime;
                deltaTime = d + 1.0;
                if (!(d * bulletVelocity < Point2D.distance(myX, myY, predictedX, predictedY))) break block3;
            }
            do {
                predictedX += MathUtils.sin(this.myHeading.Get()) * targetVelocity;
                predictedY += MathUtils.cos(this.myHeading.Get()) * targetVelocity;
                predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);
                predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
                d = deltaTime;
                deltaTime = d + 1.0;
            } while (d * bulletVelocity < Point2D.distance(myX, myY, predictedX, predictedY));
        }
        Heading aimHdg = new Heading();
        aimHdg.SetFromTo(new Location(myX, myY), new Location(predictedX, predictedY));
        Bearing aimBrg = new Bearing();
        aimBrg.Set(aimHdg);
        return aimBrg.Get() - this.bearingAbsolute.Get();
    }

    public double getBearingOffsetForTargettingMovingAvgVelocity(double bulletVelocity) {
        this.setTargettingMethod(3);
        return this.getBearingOffsetForTargettingLinearWithVelocity(bulletVelocity, this.velocityMovingAverage);
    }

    public double getBearingOffsetForTargettingCircular(double bulletVelocity) {
        this.setTargettingMethod(4);
        return this.getBearingForTargettingCircular(5, this.distance / bulletVelocity, bulletVelocity) - this.bearingAbsolute.Get();
    }

    public double getBearingForTargettingCircular(int loops, double timeForImpact, double bulletVelocity) {
        double newX = this.location.GetX();
        double newY = this.location.GetY();
        AdvancedRobot r = GameInfo.getRobot();
        double timeNow = GameInfo.getTime();
        int i = 0;
        while (i < 10) {
            double nextTime = (int)Math.round(this.getrange(r.getX(), r.getY(), newX, newY) / bulletVelocity);
            double time = timeNow + nextTime;
            double diff = time - this.timeUpdated;
            double radius = this.speed / Math.toRadians(this.headingDelta);
            double tothead = diff * this.headingDelta;
            double heading = this.myHeading.Get();
            newY = this.location.GetY() + MathUtils.sin(heading + tothead) * radius - MathUtils.sin(heading) * radius;
            newX = this.location.GetX() + MathUtils.cos(heading) * radius - MathUtils.cos(heading + tothead) * radius;
            newX = Math.min(Math.max(18.0, newX), GameInfo.battleFieldWidth - 18.0);
            newY = Math.min(Math.max(18.0, newY), GameInfo.battleFieldHeight - 18.0);
            ++i;
        }
        double gunOffset = 90.0 - MathUtils.atan2(newY - r.getY(), newX - r.getX());
        return gunOffset;
    }

    public Location guessPosition(double x, double y, double when, double heading) {
        double timeDiff = when - this.timeUpdated;
        double radius = this.speedMovingAverage / Math.toRadians(this.headingDeltaMovingAverage);
        double tothead = timeDiff * this.headingDelta;
        double newY = y + MathUtils.sin(heading + tothead) * radius - MathUtils.sin(heading) * radius;
        double newX = x + MathUtils.cos(heading) * radius - MathUtils.cos(heading + tothead) * radius;
        return new Location(newX, newY);
    }

    public double getrange(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = Math.sqrt(xo * xo + yo * yo);
        return h;
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public boolean equals(Object obj) {
        return obj instanceof RobotData && ((RobotData)obj).getName().equals(this.name);
    }
}

