/*
 * Decompiled with CFR 0.152.
 */
package ab;

import java.awt.geom.Point2D;

public class Utilities {
    public static double bulletSpeed(double power) {
        return 20.0 - 3.0 * power;
    }

    public static Point2D.Double project(Point2D sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.getX() + Math.sin(angle) * length, sourceLocation.getY() + Math.cos(angle) * length);
    }

    static double absBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }

    public static int sign(double v) {
        return v < 0.0 ? -1 : 1;
    }

    public static int minMax(int v, int min, int max) {
        return Math.max(min, Math.min(max, v));
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double maxEscapeAngle(double velocity) {
        return Math.asin(8.0 / velocity);
    }

    public static double normalize(double angle) {
        if (angle > -Math.PI && angle <= Math.PI) {
            return angle;
        }
        double fixedAngle = angle;
        while (fixedAngle <= -Math.PI) {
            fixedAngle += Math.PI * 2;
        }
        while (fixedAngle > Math.PI) {
            fixedAngle -= Math.PI * 2;
        }
        return fixedAngle;
    }
}

