/*
 * Decompiled with CFR 0.152.
 */
package mue;

import mue.Position;
import mue.RobotData;
import mue.Util;
import robocode.Robot;

class FireSnapshot {
    private double originX = 0.0;
    private double originY = 0.0;
    private double targetX;
    private double targetY;
    private double distance;
    private double velocity;
    private double heading;
    private double energy;
    private double lastVelocity;
    private int orbitDirection;
    private double averageVelocity;
    private int acceleration;
    private double angularVelocity;
    private double averageAngularVelocity;
    private int angularAcceleration;
    private double averageHeading;
    private double power;
    private int timeSinceLastAcceleration;
    private int timeSinceLastDeceleration;
    private long time;
    private double targetAngle;
    private double escapeAngle;

    public FireSnapshot(RobotData robotData, double d) {
        Position position = robotData.guessPosition();
        this.targetX = position.getX();
        this.targetY = position.getY();
        this.distance = 0.0;
        this.velocity = robotData.getVelocity();
        this.lastVelocity = robotData.getLastVelocity();
        this.orbitDirection = robotData.getOrbitDirection();
        this.heading = robotData.getHeading();
        this.energy = robotData.getEnergy();
        this.averageVelocity = robotData.getAverageVelocity();
        this.acceleration = robotData.getAcceleration();
        this.angularVelocity = robotData.getAngularVelocity();
        this.averageAngularVelocity = robotData.getAverageAngularVelocity();
        this.angularAcceleration = robotData.getAngularAcceleration();
        this.averageHeading = robotData.getAverageHeading();
        this.power = d;
        this.timeSinceLastAcceleration = robotData.getTimeSinceLastAcceleration();
        this.timeSinceLastDeceleration = robotData.getTimeSinceLastDeceleration();
        this.time = 0L;
    }

    public void setRobot(Robot robot) {
        this.originX = robot.getX();
        this.originY = robot.getY();
        this.time = robot.getTime();
        this.distance = Util.distance(this.originX, this.originY, this.targetX, this.targetY);
        this.targetAngle = Util.direction(this.originX, this.originY, this.targetX, this.targetY);
        this.escapeAngle = Math.toDegrees(Math.asin(8.0 * Math.ceil(this.distance / (20.0 - 3.0 * this.power)) / this.distance));
        if (this.orbitDirection == -1) {
            this.escapeAngle *= -1.0;
        }
    }

    public final double getOriginX() {
        return this.originX;
    }

    public final double getOriginY() {
        return this.originY;
    }

    public final double getTargetX() {
        return this.targetX;
    }

    public final double getTargetY() {
        return this.targetY;
    }

    public final double getDistance() {
        return this.distance;
    }

    public final double getVelocity() {
        return this.velocity;
    }

    public final double getLastVelocity() {
        return this.lastVelocity;
    }

    public final int getOrbitDirection() {
        return this.orbitDirection;
    }

    public final double getHeading() {
        return this.heading;
    }

    public final double getEnergy() {
        return this.energy;
    }

    public final double getAverageVelocity() {
        return this.averageVelocity;
    }

    public final int getAcceleration() {
        return this.acceleration;
    }

    public final double getAngularVelocity() {
        return this.angularVelocity;
    }

    public final double getAverageAngularVelocity() {
        return this.averageAngularVelocity;
    }

    public final int getAngularAcceleration() {
        return this.angularAcceleration;
    }

    public double getAverageHeading() {
        return this.averageHeading;
    }

    public final double getPower() {
        return this.power;
    }

    public final int getTimeSinceLastAcceleration() {
        return this.timeSinceLastAcceleration;
    }

    public final int getTimeSinceLastDeceleration() {
        return this.timeSinceLastDeceleration;
    }

    public final double getGuessFactor(double d, double d2) {
        return this.getGuessFactor(Util.direction(this.originX, this.originY, d, d2));
    }

    public final double getGuessFactor(double d) {
        return Util.confine(Util.relativeAngle(this.targetAngle, d) / this.escapeAngle, -1.0, 1.0);
    }

    public final long getTime() {
        return this.time;
    }
}

