/*
 * Decompiled with CFR 0.152.
 */
package stordy;

import java.util.ArrayList;
import stordy.ForcePoint;
import stordy.Vec2d;

class VirtualBullet {
    private Vec2d firePosition;
    private Vec2d fireMovementVector;
    private Vec2d predictedHitPosition;
    private long fireTime;

    public VirtualBullet(Vec2d firePosition, Vec2d fireMovementVector, long fireTime, Vec2d predictedHit) {
        this.firePosition = firePosition;
        this.fireMovementVector = fireMovementVector;
        this.fireTime = fireTime;
        this.predictedHitPosition = predictedHit;
    }

    public Vec2d getPredictedPosition(long currentTime) {
        long dTime = currentTime - this.fireTime;
        Vec2d fp = this.firePosition.add(this.fireMovementVector.multiply(dTime));
        return fp;
    }

    public Vec2d getPredictedHitPosition() {
        return this.predictedHitPosition;
    }

    public Vec2d getFirePosition() {
        return this.firePosition;
    }

    public ArrayList<ForcePoint> getGravPoints(long currentTime) {
        ArrayList<ForcePoint> fpa = new ArrayList<ForcePoint>();
        fpa.add(new ForcePoint(this.predictedHitPosition, 600.0));
        fpa.add(new ForcePoint(this.getPredictedPosition(currentTime), 13.0));
        return fpa;
    }

    public boolean stillValid(long currentTime) {
        if (this.fireMovementVector.getMagnitude() < 0.01) {
            return true;
        }
        Vec2d cPos = this.getPredictedPosition(currentTime);
        double xMoveDir = Math.signum(this.fireMovementVector.getX());
        if (xMoveDir * cPos.getX() > xMoveDir * this.predictedHitPosition.getX()) {
            return false;
        }
        double yMoveDir = Math.signum(this.fireMovementVector.getY());
        return !(yMoveDir * cPos.getY() > yMoveDir * this.predictedHitPosition.getY());
    }
}

