/*
 * Decompiled with CFR 0.152.
 */
package jbot.tracer;

import jbot.Rabbit2;
import jbot.tracer.Target;
import jbot.tracer.Tracer;
import jbot.util.MathUtil;
import robocode.Rules;
import robocode.util.Utils;

public class Radar {
    private Rabbit2 mBot;
    private Target mTarget;
    private double mTurnDirIfTargetLost = 1.0;
    private int mTargetLostFrames = 0;

    public Radar(Tracer tracer) {
        this.mBot = tracer.mBot;
        this.mTarget = tracer.mTarget;
    }

    public void frame(double deltaTime) {
        if (this.mTargetLostFrames > 0) {
            this.searchTarget();
        }
        ++this.mTargetLostFrames;
    }

    private void searchTarget() {
        this.mTarget.mIsLocked = false;
        this.mBot.setTurnRadarRightRadians(Rules.RADAR_TURN_RATE_RADIANS * this.mTurnDirIfTargetLost);
    }

    public void adjustToTarget(double targetHeading) {
        this.mTargetLostFrames = 0;
        this.mTarget.mIsLocked = true;
        double radarBearingToTarget = Utils.normalRelativeAngle((double)(targetHeading - this.mBot.getRadarHeadingRadians()));
        this.mTurnDirIfTargetLost = -MathUtil.sign(radarBearingToTarget);
        radarBearingToTarget += Rules.RADAR_TURN_RATE_RADIANS / 6.0 * (double)MathUtil.sign(radarBearingToTarget);
        this.mBot.setTurnRadarRightRadians(radarBearingToTarget);
    }
}

