/*
 * Decompiled with CFR 0.152.
 */
package florent;

import florent.Context;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import robocode.ScannedRobotEvent;

public class SymbolicPatternMatcher {
    private static final boolean DEBUG = false;
    public static double NO_MACH_ANGLE = -10000.0;
    private Context context;
    int timeSinceScan;
    double enemyAbsoluteBearing;
    double deltaTime;
    double lateralVelocity;
    double lastVelocity;
    double velocity;
    double myBearing;
    double heading;
    double lastBulletVelocity;
    double angle;
    double enemyEnergy;
    double enemyBulletVelocity = 11.0;
    double enemyBulletPower;
    double bearingDirection;
    double enemyDistance;
    double time;
    double bulletPower = 3.0;
    double lastHeading = -10000.0;
    static int MOVIE_SIZE = 7000;
    static StringBuffer buffer = new StringBuffer(MOVIE_SIZE);
    static int n;
    Point2D.Double enemyLocation = new Point2D.Double();
    Point2D.Double robotLocation;
    static ArrayList movie;

    static {
        movie = new ArrayList(MOVIE_SIZE);
    }

    public SymbolicPatternMatcher(Context context) {
        this.context = context;
    }

    public void newRound() {
        this.recordFrame(new FrameBreak());
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.synch();
        this.record(this.heading - this.lastHeading, this.velocity, this.deltaTime);
    }

    public void synch() {
        if (this.context.getTime() == this.time) {
            return;
        }
        this.deltaTime = this.context.getTime() - this.time;
        this.time = this.context.getTime();
        this.enemyAbsoluteBearing = this.context.getAbsoluteBearing();
        this.enemyDistance = this.context.getDistance();
        this.robotLocation = this.context.getMyLocation();
        this.lastHeading = this.heading;
        this.heading = this.context.getHeading();
        this.enemyLocation = this.context.getEnemyLocation();
        this.velocity = this.context.getVelocity();
    }

    public double getAngle(double power) {
        int length;
        this.bulletPower = power;
        this.lastBulletVelocity = this.bulletVelocity(this.bulletPower);
        int bft = (int)(1.3 * this.enemyDistance / this.lastBulletVelocity);
        int upper = length = Math.min((int)this.time, 600);
        int maxLength = length;
        int match = -2;
        int patternLength = n - bft;
        if (length > 0 && n > maxLength + bft + 1) {
            String search = buffer.substring(n - maxLength);
            String pattern = buffer.substring(0, patternLength);
            boolean found = false;
            int matchLength = 0;
            do {
                int i;
                boolean bl = found = (i = pattern.lastIndexOf(search.substring(maxLength - length))) != -1 && patternLength > i + bft + 1;
                if (found) {
                    match = i;
                    matchLength = length;
                    continue;
                }
                upper = length;
            } while ((length = found ? length + (upper - length) / 2 : length / 2) > 0 && length < upper - 1);
            this.angle = match < 0 ? NO_MACH_ANGLE : this.projectedBearing(match + matchLength) - this.enemyAbsoluteBearing;
        } else {
            this.angle = NO_MACH_ANGLE;
        }
        return this.angle;
    }

    private double normalRelativeAngle(double angle) {
        return Math.atan2(Math.sin(angle), Math.cos(angle));
    }

    private double projectedBearing(long index) {
        double newX = this.enemyLocation.x;
        double newY = this.enemyLocation.y;
        double heading = this.lastHeading;
        long travelTime = 0L;
        long bulletTravelTime = 0L;
        if (index > 0L) {
            int i = (int)index;
            while (i < n && travelTime <= bulletTravelTime) {
                Frame frame = (Frame)movie.get(i);
                heading = this.normalRelativeAngle(heading + frame.getDeltaHeading());
                bulletTravelTime = (long)(this.robotLocation.distance(newX += frame.getVelocity() * Math.sin(heading), newY += frame.getVelocity() * Math.cos(heading)) / this.lastBulletVelocity);
                ++travelTime;
                ++i;
            }
        }
        return this.absoluteBearing(this.robotLocation, new Point2D.Double(newX, newY));
    }

    double bulletVelocity(double power) {
        return 20.0 - 3.0 * power;
    }

    private double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }

    void record(double deltaHeading, double velocity, double deltaTime) {
        Frame frame = new Frame(deltaHeading / deltaTime, velocity / deltaTime);
        int i = 0;
        while ((double)i < deltaTime) {
            this.recordFrame(frame);
            ++i;
        }
    }

    void recordFrame(Frame frame) {
        buffer.append(frame.getKey());
        movie.add(frame);
        if (n == MOVIE_SIZE) {
            buffer.deleteCharAt(0);
            movie.remove(0);
        } else {
            ++n;
        }
    }

    class Frame {
        double deltaHeading;
        double velocity;

        public Frame(double deltaHeading, double velocity) {
            this.deltaHeading = deltaHeading;
            this.velocity = velocity;
        }

        char getKey() {
            return (char)((int)this.velocity + 8 + 11 * (int)((10.0 + Math.toDegrees(this.deltaHeading)) * 3.0));
        }

        public double getDeltaHeading() {
            return this.deltaHeading;
        }

        public double getVelocity() {
            return this.velocity;
        }
    }

    class FrameBreak
    extends Frame {
        double deltaHeading;
        double velocity;

        public FrameBreak() {
            super(0.0, 0.0);
        }

        char getKey() {
            return '\u0000';
        }
    }
}

