/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.layer;

import dmonner.xlbp.NetworkCopier;
import dmonner.xlbp.Responsibilities;
import dmonner.xlbp.layer.AbstractFanInLayer;

public class SigmaLayer
extends AbstractFanInLayer {
    private static final long serialVersionUID = 1L;

    public SigmaLayer(SigmaLayer that, NetworkCopier copier) {
        super(that, copier);
    }

    public SigmaLayer(String name, int size) {
        super(name, size);
    }

    @Override
    public void activateTest() {
        System.arraycopy(this.upstream[0].getActivations(), 0, this.y, 0, this.size);
        for (int k = 1; k < this.nUpstream; ++k) {
            float[] yk = this.upstream[k].getActivations();
            for (int j = 0; j < this.size; ++j) {
                int n = j;
                this.y[n] = this.y[n] + yk[j];
            }
        }
    }

    @Override
    public void activateTrain() {
        this.activateTest();
    }

    @Override
    public void aliasResponsibilities(int index, Responsibilities resp) {
        super.aliasResponsibilities(index, resp);
        for (int i = 0; i < this.nUpstream; ++i) {
            this.upstream[i].aliasResponsibilities(this.myIndexInUpstream[i], resp);
        }
    }

    @Override
    public void build() {
        if (!this.built) {
            super.build();
            this.y = new float[this.size];
            this.d = new Responsibilities(this.size);
            for (int i = 0; i < this.nUpstream; ++i) {
                this.upstream[i].build();
                this.upstream[i].aliasResponsibilities(this.myIndexInUpstream[i], this.d);
            }
            this.built = true;
        }
    }

    @Override
    public SigmaLayer copy(NetworkCopier copier) {
        return new SigmaLayer(this, copier);
    }

    @Override
    public SigmaLayer copy(String nameSuffix) {
        return this.copy(new NetworkCopier(nameSuffix));
    }

    @Override
    public void updateEligibilities() {
        if (this.downstreamCopyLayer != null) {
            this.downstream.updateUpstreamResponsibilities(this.myIndexInDownstream);
        }
    }

    @Override
    public void updateResponsibilities() {
        if (this.downstreamCopyLayer == null) {
            this.downstream.updateUpstreamResponsibilities(this.myIndexInDownstream);
        }
    }

    @Override
    public void updateUpstreamResponsibilities(int index) {
    }
}

