/*
 * Decompiled with CFR 0.152.
 */
package rdt.AgentSmith.DangerPrediction;

import rdt.AgentSmith.DangerPrediction.CachedVelocityData;
import rdt.AgentSmith.DangerPrediction.Evaluators.ClosestDistanceToEachBullet;
import rdt.AgentSmith.DangerPrediction.IMovementSearch;
import rdt.AgentSmith.DangerPrediction.MovementCommand;
import rdt.AgentSmith.DangerPrediction.PredictedRobotState;
import rdt.AgentSmith.DangerPrediction.Search.RHEA;
import rdt.AgentSmith.EnemyPrediction.BulletPrediction;
import rdt.AgentSmith.EnemyPrediction.IEnemyPredictionEventHandler;
import rdt.AgentSmith.EnemyPrediction.IEnemyPredictionManager;
import rdt.AgentSmith.IRobot;
import rdt.AgentSmith.IRoundStartedEventHandler;
import rdt.AgentSmith.Profiling.Profiler;
import rdt.AgentSmith.Stats.Average;
import rdt.AgentSmith.Stats.IStats;

public class DangerPrediction
implements IEnemyPredictionEventHandler,
IRoundStartedEventHandler {
    private IRobot _robot;
    private IMovementSearch _movementSearch;
    private IEnemyPredictionManager _enemyPredictionManager;
    private boolean _resetSearch;
    private final int _minActiveSequenceLength;
    private int _iterations = 0;
    private int _rolls = 0;
    private final Average _averageIterationsBetweenResets = new Average("DangerPrediction : Iterations Between Resets");
    private final Average _averageRollsBetweenResets = new Average("DangerPrediction : Rolls Between Resets");
    private PredictedRobotState _currentRobotState = new PredictedRobotState();
    private PredictedRobotState _nextRobotState = new PredictedRobotState();

    public DangerPrediction(IRobot robot, IEnemyPredictionManager enemyPredictionManager, IStats stats) {
        this._robot = robot;
        this._enemyPredictionManager = enemyPredictionManager;
        stats.RegisterStat(this._averageIterationsBetweenResets);
        stats.RegisterStat(this._averageRollsBetweenResets);
        this._resetSearch = true;
        this._robot.RegisterForEventHandling(this);
        enemyPredictionManager.RegisterForEventHandling(this);
        int commandSequenceLength = 100;
        double maxBattlefieldDimension = Math.max(this._robot.getBattleFieldWidth(), this._robot.getBattleFieldHeight());
        double ticksToEscapeCorner = maxBattlefieldDimension * 0.5 / 8.0;
        this._minActiveSequenceLength = (int)ticksToEscapeCorner;
        this._movementSearch = new RHEA(new ClosestDistanceToEachBullet(this._robot, enemyPredictionManager, commandSequenceLength), commandSequenceLength);
    }

    public void Update() {
        Profiler.StartScope("DangerPrediction:Update");
        if (this._resetSearch) {
            this._movementSearch.Reset(this.CalcActiveSequenceLength());
            this._averageIterationsBetweenResets.Record(this._iterations);
            this._averageRollsBetweenResets.Record(this._rolls);
            this._iterations = 0;
            this._rolls = 0;
            this._resetSearch = false;
        }
        for (int iterationCount = 0; iterationCount < 2; ++iterationCount) {
            this._movementSearch.RunOneIteration();
            ++this._iterations;
        }
        int bestCommand = this._movementSearch.GetBestMovementCommand();
        this.ExecuteCommand(bestCommand);
        this.UpdateNextRobotPosition(bestCommand);
        this._movementSearch.Roll(bestCommand);
        ++this._rolls;
        Profiler.EndScope();
    }

    @Override
    public void OnRoundStartedEvent() {
        this._resetSearch = true;
    }

    @Override
    public void OnEnemyPredictionChangedEvent() {
        this._resetSearch = true;
    }

    private void ExecuteCommand(int movementCommand) {
        switch (movementCommand) {
            case 0: {
                this._robot.setAhead(1000.0);
                this._robot.setTurnLeft(0.0);
                break;
            }
            case 3: {
                this._robot.setBack(1000.0);
                this._robot.setTurnLeft(0.0);
                break;
            }
            case 1: {
                this._robot.setAhead(1000.0);
                this._robot.setTurnLeft(180.0);
                break;
            }
            case 5: {
                this._robot.setBack(1000.0);
                this._robot.setTurnLeft(180.0);
                break;
            }
            case 2: {
                this._robot.setAhead(1000.0);
                this._robot.setTurnRight(180.0);
                break;
            }
            case 4: {
                this._robot.setBack(1000.0);
                this._robot.setTurnRight(180.0);
            }
        }
    }

    private int CalcActiveSequenceLength() {
        int bullets = this._enemyPredictionManager.GetBulletPredictionCount();
        if (bullets <= 0) {
            return this._minActiveSequenceLength;
        }
        BulletPrediction[] bulletPredictions = this._enemyPredictionManager.GetBulletPredictions();
        long maxPredictionTick = 0L;
        for (int bulletIndex = 0; bulletIndex < bullets; ++bulletIndex) {
            BulletPrediction bulletPrediction = bulletPredictions[bulletIndex];
            maxPredictionTick = Math.max(maxPredictionTick, bulletPrediction.PredictionDeactivationTime);
        }
        long ticksForAllBulletsToLeaveBattlefield = maxPredictionTick + bulletPredictions[0].TickPredictionWasGenerated - this._robot.getTime();
        return Math.max(this._minActiveSequenceLength, (int)ticksForAllBulletsToLeaveBattlefield);
    }

    private void UpdateNextRobotPosition(int command) {
        this._currentRobotState.X = this._robot.getX();
        this._currentRobotState.Y = this._robot.getY();
        this._currentRobotState.Heading = this._robot.getHeadingRadians();
        this._currentRobotState.Velocity = this._robot.getVelocity();
        CachedVelocityData cachedVelocityData = CachedVelocityData.Get(this._currentRobotState.Velocity);
        MovementCommand.PredictCommandFast(command, this._currentRobotState, this._nextRobotState, cachedVelocityData);
        this._robot.SetNextX(this._nextRobotState.X);
        this._robot.SetNextY(this._nextRobotState.Y);
    }
}

