/*
 * Decompiled with CFR 0.152.
 */
package apc.movement;

import apc.movement.Wave;
import apc.utils.HelperMethods;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Dodge {
    private AdvancedRobot _myBot;
    private Point2D.Double _myLocation;
    public static int BINS = 47;
    public static double[] _surfStats = new double[BINS];
    public Point2D.Double _enemyLocation;
    public ArrayList<Wave> _enemyWaves = new ArrayList();
    public ArrayList<Integer> _surfDirections = new ArrayList();
    public ArrayList<Double> _surfAbsBearings = new ArrayList();
    public static double _oppEnergy = 100.0;

    public Dodge(AdvancedRobot bot) {
        this._myBot = bot;
    }

    public ArrayList<Wave> onScannedRobot(ScannedRobotEvent e) {
        this._myLocation = new Point2D.Double(this._myBot.getX(), this._myBot.getY());
        double lateralVelocity = this._myBot.getVelocity() * Math.sin(e.getBearingRadians());
        double absBearing = e.getBearingRadians() + this._myBot.getHeadingRadians();
        this._myBot.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(absBearing - this._myBot.getRadarHeadingRadians())) * 2.0);
        this._surfDirections.add(new Integer(lateralVelocity >= 0.0 ? 1 : -1));
        this._surfAbsBearings.add(new Double(absBearing + Math.PI));
        double bulletPower = _oppEnergy - e.getEnergy();
        if (bulletPower < 3.01 && bulletPower > 0.09 && this._surfDirections.size() > 2) {
            Wave wave = new Wave();
            wave.setFireTime(this._myBot.getTime() - 1L);
            wave.setBulletVelocity(HelperMethods.bulletVelocity(bulletPower));
            wave.setDistanceTraveled(HelperMethods.bulletVelocity(bulletPower));
            wave.setDirection(this._surfDirections.get(2));
            wave.setDirectAngle(this._surfAbsBearings.get(2));
            wave.setFireLocation((Point2D.Double)this._enemyLocation.clone());
            this._enemyWaves.add(wave);
        }
        _oppEnergy = e.getEnergy();
        this._enemyLocation = HelperMethods.project(this._myLocation, absBearing, e.getDistance());
        this.updateWaves();
        this.doSurfing();
        return this._enemyWaves;
    }

    public void updateWaves() {
        int x = 0;
        while (x < this._enemyWaves.size()) {
            Wave wave = this._enemyWaves.get(x);
            wave.setDistanceTraveled((double)(this._myBot.getTime() - wave.fireTime()) * wave.bulletVelocity());
            if (wave.distanceTraveled() > this._myLocation.distance(wave.fireLocation()) + 50.0) {
                this._enemyWaves.remove(x);
                --x;
            }
            ++x;
        }
    }

    public double checkDanger(Wave surfWave, int direction) {
        int index = Dodge.getFactorIndex(surfWave, this.predictPosition(surfWave, direction));
        return _surfStats[index];
    }

    public void doSurfing() {
        Wave surfWave = this.getClosestSurfableWave();
        if (surfWave == null) {
            return;
        }
        double dangerLeft = this.checkDanger(surfWave, -1);
        double dangerRight = this.checkDanger(surfWave, 1);
        double goAngle = HelperMethods.absoluteBearing(surfWave.fireLocation(), this._myLocation);
        goAngle = dangerLeft < dangerRight ? HelperMethods.wallSmoothing(this._myLocation, goAngle - 1.5707963267948966, -1) : HelperMethods.wallSmoothing(this._myLocation, goAngle + 1.5707963267948966, 1);
        HelperMethods.setBackAsFront(this._myBot, goAngle);
    }

    public Point2D.Double predictPosition(Wave surfWave, int direction) {
        Point2D.Double predictedPosition = (Point2D.Double)this._myLocation.clone();
        double predictedVelocity = this._myBot.getVelocity();
        double predictedHeading = this._myBot.getHeadingRadians();
        int counter = 0;
        boolean intercepted = false;
        do {
            double moveAngle = HelperMethods.wallSmoothing(predictedPosition, HelperMethods.absoluteBearing(surfWave.fireLocation(), predictedPosition) + (double)direction * 1.5707963267948966, direction) - predictedHeading;
            double moveDir = 1.0;
            if (Math.cos(moveAngle) < 0.0) {
                moveAngle += Math.PI;
                moveDir = -1.0;
            }
            moveAngle = Utils.normalRelativeAngle((double)moveAngle);
            double maxTurning = 0.004363323129985824 * (40.0 - 3.0 * Math.abs(predictedVelocity));
            predictedHeading = Utils.normalRelativeAngle((double)(predictedHeading + HelperMethods.limit(-maxTurning, moveAngle, maxTurning)));
            predictedVelocity += predictedVelocity * moveDir < 0.0 ? 2.0 * moveDir : moveDir;
            predictedVelocity = HelperMethods.limit(-8.0, predictedVelocity, 8.0);
            predictedPosition = HelperMethods.project(predictedPosition, predictedHeading, predictedVelocity);
            ++counter;
            if (!(predictedPosition.distance(surfWave.fireLocation()) < surfWave.distanceTraveled() + (double)counter * surfWave.bulletVelocity() + surfWave.bulletVelocity())) continue;
            intercepted = true;
        } while (!intercepted && counter < 500);
        return predictedPosition;
    }

    public static int getFactorIndex(Wave ew, Point2D.Double targetLocation) {
        double offsetAngle = HelperMethods.absoluteBearing(ew.fireLocation(), targetLocation) - ew.directAngle();
        double factor = Utils.normalRelativeAngle((double)offsetAngle) / HelperMethods.maxEscapeAngle(ew.bulletVelocity()) * ew.direction();
        return (int)HelperMethods.limit(0.0, factor * (double)((BINS - 1) / 2) + (double)((BINS - 1) / 2), BINS - 1);
    }

    public Wave getClosestSurfableWave() {
        double closestDistance = 50000.0;
        Wave surfWave = null;
        int x = 0;
        while (x < this._enemyWaves.size()) {
            Wave ew = this._enemyWaves.get(x);
            double distance = this._myLocation.distance(ew.fireLocation()) - ew.distanceTraveled();
            if (distance > ew.bulletVelocity() && distance < closestDistance) {
                surfWave = ew;
                closestDistance = distance;
            }
            ++x;
        }
        return surfWave;
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (!this._enemyWaves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            Wave hitWave = null;
            int x = 0;
            while (x < this._enemyWaves.size()) {
                Wave ew = this._enemyWaves.get(x);
                if (Math.abs(ew.distanceTraveled() - this._myLocation.distance(ew.fireLocation())) < 50.0 && Math.abs(HelperMethods.bulletVelocity(e.getBullet().getPower()) - ew.bulletVelocity()) < 0.001) {
                    hitWave = ew;
                    break;
                }
                ++x;
            }
            if (hitWave != null) {
                this.logHit(hitWave, hitBulletLocation);
                this._enemyWaves.remove(this._enemyWaves.lastIndexOf(hitWave));
            }
        }
    }

    public void logHit(Wave ew, Point2D.Double targetLocation) {
        int index = Dodge.getFactorIndex(ew, targetLocation);
        int x = 0;
        while (x < BINS) {
            int n = x;
            _surfStats[n] = _surfStats[n] + 1.0 / (Math.pow(index - x, 2.0) + 1.0);
            ++x;
        }
    }

    public void move() {
    }
}

