/*
 * Decompiled with CFR 0.152.
 */
package alk.lap.strategy.analysis;

import alk.lap.LoudAndProud;
import alk.lap.strategy.FireWave;
import alk.lap.strategy.StatisticWave;
import alk.lap.strategy.analysis.Analyst;
import alk.lap.strategy.analysis.Recommendation;
import alk.lap.strategy.targetting.BulletBeam;
import alk.lap.utils.DVektor;

public class EnemyFireAnalyst
implements Analyst {
    LoudAndProud proud;

    public EnemyFireAnalyst(LoudAndProud proud) {
        this.proud = proud;
    }

    public Recommendation analyse(LoudAndProud proud) {
        return null;
    }

    public void newRound(LoudAndProud proud) {
    }

    public void analyseHit(DVektor hitPosition, double power) {
        FireWave emittingWave = null;
        for (FireWave currentWave : this.proud.getTacticLead().getFireWaves()) {
            if (currentWave instanceof StatisticWave || !(Math.abs(hitPosition.getDistanceTo(currentWave.emittingPosition) - currentWave.getCurrentRadius()) < 20.0)) continue;
            emittingWave = currentWave;
        }
        if (emittingWave != null) {
            double angleToHit = emittingWave.emittingPosition.getDirectionTo(hitPosition);
            BulletBeam[] beams = emittingWave.getPossibleBulletVelocities();
            int i = 0;
            while (i < beams.length) {
                BulletBeam beam = beams[i];
                if (Math.abs(beam.vDirect.getDirection() - angleToHit) <= beam.beamAngle) {
                    this.proud.getStrategicLead().getAnalystsDB().incrementHitForEnemyStrategy(beam.source, 16);
                }
                ++i;
            }
        } else {
            this.proud.log("No Wave identified");
        }
    }
}

