/*
 * Decompiled with CFR 0.152.
 */
package jwirde;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import jwirde.CoordUtils;
import jwirde.Environment;
import jwirde.Ghost;
import jwirde.MovementStrategy;
import jwirde.VectPol;
import robocode.AdvancedRobot;

public class StrafingMovement
implements MovementStrategy {
    private static final int CLOSING_IN_DISTANCE = 400;
    private static final long TICKS_TO_CHANGE_DIRECTION = 40L;
    private final Environment env;
    private final AdvancedRobot myRobot;
    private int direction = 1;
    private long latestDirectionChange;

    public StrafingMovement(AdvancedRobot myRobot, Environment env) {
        this.env = env;
        this.myRobot = myRobot;
        this.latestDirectionChange = myRobot.getTime();
    }

    @Override
    public void moveRobot() {
        Ghost target = this.findTarget();
        if (target == null) {
            return;
        }
        Point2D.Double myPos = new Point2D.Double(this.myRobot.getX(), this.myRobot.getY());
        double angle = CoordUtils.getRelativeAngle(myPos, target.coord, this.myRobot.getHeadingRadians()) + 1.5707963267948966;
        if (target.distance > 400.0) {
            angle -= 0.2 * (double)this.direction;
        }
        this.myRobot.setTurnRightRadians(angle);
        this.changeDirection(false);
        this.myRobot.setAhead((double)(10 * this.direction));
    }

    private void changeDirection(boolean force) {
        if (force || this.myRobot.getTime() - this.latestDirectionChange > 40L) {
            this.direction *= -1;
            this.latestDirectionChange = this.myRobot.getTime();
        }
    }

    private Ghost findTarget() {
        if (this.env.getFoes().size() == 0) {
            return null;
        }
        return this.env.getFoes().iterator().next();
    }

    @Override
    public void onPaint(Graphics2D g) {
        Ghost target = this.findTarget();
        if (target == null) {
            return;
        }
        Point2D.Double myPos = new Point2D.Double(this.myRobot.getX(), this.myRobot.getY());
        CoordUtils.drawVect(g, Color.GREEN, myPos, new VectPol(target.bearing + this.myRobot.getHeadingRadians() + 1.5707963267948966, 100.0));
    }

    @Override
    public void onHitByBullet(Ghost shooter) {
        this.changeDirection(true);
    }
}

