/*
 * Decompiled with CFR 0.152.
 */
package rijteam;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class EnemyBullet {
    private double VX;
    private double VY;
    private double AX;
    private double OriginX;
    private double OriginY;
    private double Distance;
    public double BulletHeading;
    public double BulletPower;
    private long StartingTick;
    private double BulletVelocity;
    public Line2D BulletTrajectory;

    public double getBulletDistance(long t) {
        return (double)(t - this.StartingTick) * this.BulletVelocity;
    }

    public double getBulletX(long t) {
        return this.OriginX + (double)(t - this.StartingTick) * this.BulletVelocity * Math.sin(this.BulletHeading);
    }

    public double getBulletY(long t) {
        return this.OriginY + (double)(t - this.StartingTick) * this.BulletVelocity * Math.cos(this.BulletHeading);
    }

    public boolean isBulletMissed(long t, double curX, double curY) {
        return Point2D.distance(curX, curY, this.OriginX, this.OriginY) < (double)(t - this.StartingTick) * this.BulletVelocity;
    }

    public Point2D findClosest(Point2D origin) {
        Point2D.Double closestPoint = new Point2D.Double();
        double m = Math.tan(this.BulletHeading);
        double y1 = origin.getY();
        double x1 = origin.getX();
        double b = y1 - x1 * m;
        ((Point2D)closestPoint).setLocation((Math.pow(m, 2) * y1 + m * x1 + b) / (Math.pow(m, 2) + 1.0), (m * y1 + x1 + b * m) / (Math.pow(m, 2) + 1.0));
        return closestPoint;
    }

    public EnemyBullet(double eX, double eY, double eHeading, double eDistance, long tick, double bulletPower) {
        this.OriginX = eX;
        this.OriginY = eY;
        this.Distance = eDistance;
        this.StartingTick = tick;
        this.BulletHeading = eHeading;
        this.BulletPower = bulletPower;
        this.BulletVelocity = 20.0 - bulletPower * (double)3;
    }
}

