/*
 * Decompiled with CFR 0.152.
 */
package catcat20.helios.move;

import catcat20.helios.rader.HeliosRadar;
import catcat20.helios.robot.Bot;
import catcat20.helios.robot.BotState;
import catcat20.helios.utils.HUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import robocode.TeamRobot;
import robocode.util.Utils;

public class NonWaveMove {
    public TeamRobot robot;
    public boolean isMelee = false;
    public String myName;
    Rectangle2D.Double field;
    Point2D.Double myPos;
    Point2D.Double centerPos;
    double myEnergy;

    public NonWaveMove(TeamRobot _robot) {
        this.robot = _robot;
        this.field = new Rectangle2D.Double(0.0, 0.0, this.robot.getBattleFieldWidth(), this.robot.getBattleFieldHeight());
        this.myName = this.robot.getName();
        this.centerPos = new Point2D.Double(this.robot.getBattleFieldWidth() / 2.0, this.robot.getBattleFieldHeight() / 2.0);
    }

    public void onTick() {
        BotState en;
        this.myEnergy = this.robot.getEnergy();
        this.isMelee = this.robot.getOthers() > 1;
        this.myPos = new Point2D.Double(this.robot.getX(), this.robot.getY());
        Bot nearestBot = HeliosRadar.nearestBot;
        if (nearestBot != null && (en = nearestBot.currentState) != null) {
            Object pos;
            Graphics2D g = this.robot.getGraphics();
            ArrayList<Object> poss = new ArrayList<Object>();
            Object bestPos = null;
            double bestRisk = Double.POSITIVE_INFINITY;
            if (!this.isMelee) {
                int i;
                for (double j = 0.0; j < 10.0; j += 1.0) {
                    double ran = Math.random() * 36.0;
                    for (i = 0; i < 360; i += 10) {
                        Pos pos2 = new Pos();
                        pos2.pos = HUtils.project(this.myPos, Math.toRadians((double)i + ran), Math.random() * 200.0);
                        pos2.pos = this.chkOutOfField(pos2.pos);
                        pos2.risk = this.getRisk(pos2.pos, en);
                        if (bestRisk > pos2.risk) {
                            bestPos = pos2;
                            bestRisk = pos2.risk;
                        }
                        poss.add(pos2);
                    }
                }
                double battleWidth = this.robot.getBattleFieldWidth();
                double battleHeight = this.robot.getBattleFieldHeight();
                for (i = 0; i < 30; ++i) {
                    for (int j = 0; j < 30; ++j) {
                        pos = new Pos();
                        ((Pos)pos).pos = new Point2D.Double((double)i * (battleWidth / 30.0) + Math.random() * (battleWidth / 60.0) - battleWidth / 60.0, (double)j * (battleHeight / 30.0) + Math.random() * (battleHeight / 60.0) - battleHeight / 60.0);
                        ((Pos)pos).pos = this.chkOutOfField(((Pos)pos).pos);
                        ((Pos)pos).risk = this.getRisk(((Pos)pos).pos, en);
                        if (bestRisk > ((Pos)pos).risk) {
                            bestPos = pos;
                            bestRisk = ((Pos)pos).risk;
                        }
                        poss.add(pos);
                    }
                }
            } else {
                double count = 100.0;
                double length = 100.0 + Math.random() * 100.0;
                length = Math.min(en.getPosition().distance(this.myPos), length);
                for (double i = 0.0; i < 360.0; i += 360.0 / count) {
                    pos = new Pos();
                    ((Pos)pos).pos = HUtils.project(this.myPos, Math.toRadians(i), length);
                    ((Pos)pos).pos = this.chkOutOfField(((Pos)pos).pos);
                    ((Pos)pos).risk = this.getRisk(((Pos)pos).pos, en);
                    if (bestRisk > ((Pos)pos).risk) {
                        bestPos = pos;
                        bestRisk = ((Pos)pos).risk;
                    }
                    poss.add(pos);
                }
            }
            if (bestPos != null) {
                this.goTo(((Pos)bestPos).pos);
            }
            double[] risks = new double[poss.size()];
            int x = 0;
            double lowestRisk = Double.POSITIVE_INFINITY;
            double highestRisk = Double.NEGATIVE_INFINITY;
            for (Pos pos2 : poss) {
                risks[x++] = pos2.risk;
                if (pos2.risk < lowestRisk) {
                    lowestRisk = pos2.risk;
                }
                if (!(pos2.risk > highestRisk)) continue;
                highestRisk = pos2.risk;
            }
            double avg = NonWaveMove.average(risks);
            double stDev = NonWaveMove.standardDeviation(risks);
            for (Pos pos3 : poss) {
                g.setColor(NonWaveMove.riskColor(pos3.risk - lowestRisk, avg - lowestRisk, stDev, true, 1.0));
                if (pos3.risk <= bestRisk || pos3.risk <= lowestRisk) {
                    g.setColor(Color.yellow);
                }
                g.fillOval((int)pos3.pos.x - 3, (int)pos3.pos.y - 3, 6, 6);
            }
            if (bestPos != null) {
                g.setColor(Color.yellow);
                g.fillOval((int)((Pos)bestPos).pos.x - 5, (int)((Pos)bestPos).pos.y - 5, 10, 10);
            }
        }
    }

    public double getDuelRisk(Point2D.Double pos, BotState enemy) {
        double risk = 0.0;
        double absBearing = HUtils.absoluteBearing(enemy.getPosition(), this.myPos);
        double goAngle = HUtils.absoluteBearing(this.myPos, pos);
        double sui = 1.0 + Math.abs(Math.cos(absBearing - goAngle));
        sui = Math.pow(sui, 0.5);
        double dist = enemy.getPosition().distance(pos) * 1.5;
        risk += 60.0 * (1.0 + sui) / Math.pow(dist, 2.0);
        if (enemy.getEnergy() < 1.0) {
            risk -= 120.0 * (1.0 + sui) / Math.pow(dist, 2.0);
        }
        for (double[] edge : this.getEdges()) {
            risk += 5.0 / (1.0 + Line2D.ptSegDistSq(edge[0], edge[1], edge[2], edge[3], pos.x, pos.y));
        }
        for (double[] corner : this.getCorners()) {
            corner[0] = (corner[0] + enemy.getPosition().x) / 2.0;
            corner[1] = (corner[1] + enemy.getPosition().y) / 2.0;
            if (!(enemy.getPosition().distanceSq(corner[0], corner[1]) < 22500.0)) continue;
            risk += 5.0 / (1.0 + pos.distanceSq(corner[0], corner[1]));
        }
        return risk;
    }

    public double getMeleeRisk(Point2D.Double pos) {
        double risk = 0.0;
        double goAngle = HUtils.absoluteBearing(this.myPos, pos);
        for (Bot bot : HeliosRadar.enemies.values()) {
            if (!bot.alive || bot.currentState == null) continue;
            BotState en = bot.currentState;
            double energyRatio = Math.min(en.getEnergy() / this.myEnergy, 2.0);
            double distance = en.getPosition().distance(pos);
            double absBearing = HUtils.absoluteBearing(en.getPosition(), pos);
            double sui = 1.0 + Math.abs(Math.cos(absBearing - goAngle));
            risk += energyRatio * (1.0 + sui) / (distance * Math.pow(this.centerPos.distanceSq(pos), 0.125));
        }
        return risk;
    }

    public double getRisk(Point2D.Double pos, BotState enemy) {
        double risk = 0.0;
        risk = !this.isMelee ? (risk += this.getDuelRisk(pos, enemy)) : (risk += this.getMeleeRisk(pos));
        return risk;
    }

    public double[][] getCorners() {
        return new double[][]{{this.field.x, this.field.y}, {this.field.x, this.field.y + this.field.getHeight()}, {this.field.x + this.field.width, this.field.y}, {this.field.x + this.field.width, this.field.y + this.field.height}};
    }

    public double[][] getEdges() {
        return new double[][]{{this.field.x, this.field.y, this.field.x + this.field.width, this.field.y}, {this.field.x, this.field.y, this.field.x, this.field.y + this.field.height}, {this.field.x, this.field.y + this.field.height, this.field.x + this.field.width, this.field.y + this.field.height}, {this.field.x + this.field.width, this.field.y, this.field.x + this.field.width, this.field.y + this.field.height}};
    }

    public Point2D.Double chkOutOfField(Point2D.Double p) {
        return new Point2D.Double(HUtils.limit(35.0, p.x, this.field.width - 35.0), HUtils.limit(35.0, p.y, this.field.height - 35.0));
    }

    public void goTo(Point2D.Double pos) {
        pos.x -= this.robot.getX();
        pos.y -= this.robot.getY();
        double goAngle = Utils.normalRelativeAngle((double)(Math.atan2(pos.x, pos.y) - this.robot.getHeadingRadians()));
        this.robot.setTurnRightRadians(Math.atan(Math.tan(goAngle)));
        this.robot.setAhead(Math.cos(goAngle) * Math.hypot(pos.x, pos.y));
    }

    public static double standardDeviation(double[] values) {
        double avg = NonWaveMove.average(values);
        double sumSquares = 0.0;
        for (int x = 0; x < values.length; ++x) {
            sumSquares += NonWaveMove.square(avg - values[x]);
        }
        return Math.sqrt(sumSquares / (double)values.length);
    }

    public static double square(double d) {
        return d * d;
    }

    public static double average(double[] values) {
        double sum = 0.0;
        for (int x = 0; x < values.length; ++x) {
            sum += values[x];
        }
        return sum / (double)values.length;
    }

    public static Color riskColor(double risk, double avg, double stDev, boolean safestYellow, double maxStDev) {
        if (risk < 1.0E-7 && safestYellow) {
            return Color.yellow;
        }
        return new Color((int)HUtils.limit(0.0, 255.0 * (risk - (avg - maxStDev * stDev)) / (2.0 * maxStDev * stDev), 255.0), 0, (int)HUtils.limit(0.0, 255.0 * (avg + maxStDev * stDev - risk) / (2.0 * maxStDev * stDev), 255.0));
    }

    public class Pos {
        public Point2D.Double pos;
        public double risk;
    }
}

