/*
 * Decompiled with CFR 0.152.
 */
package pedersen.movement.absolute;

import java.util.LinkedList;
import pedersen.movement.MovementMethod;
import pedersen.movement.MovementMethodBase;
import pedersen.physics.Vehicle;
import pedersen.physics.constant.VehicleImpl;
import pedersen.util.Arena;

public class MovementMethodWaypointImpl
extends MovementMethodBase
implements MovementMethod {
    private int index = 0;
    private static final MovementMethod singleton = new MovementMethodWaypointImpl();
    private final LinkedList<Vehicle> waypoints = new LinkedList();
    private static final double buffer1 = 20.0;
    private static final double buffer2 = 100.0;

    public MovementMethodWaypointImpl() {
        this.waypoints.addLast(new VehicleImpl(Arena.getMinX() + 100.0, Arena.getMaxY() - 20.0, Arena.east.getAbsoluteRadians(), 8.0));
        this.waypoints.addLast(new VehicleImpl(Arena.getMaxX() - 100.0, Arena.getMaxY() - 20.0, Arena.east.getAbsoluteRadians(), 8.0));
        this.waypoints.addLast(new VehicleImpl(Arena.getMaxX() - 20.0, Arena.getMaxY() - 100.0, Arena.south.getAbsoluteRadians(), 8.0));
        this.waypoints.addLast(new VehicleImpl(Arena.getMaxX() - 20.0, Arena.getMinY() + 100.0, Arena.south.getAbsoluteRadians(), 8.0));
        this.waypoints.addLast(new VehicleImpl(Arena.getMaxX() - 100.0, Arena.getMinY() + 20.0, Arena.west.getAbsoluteRadians(), 8.0));
        this.waypoints.addLast(new VehicleImpl(Arena.getMinX() + 100.0, Arena.getMinY() + 20.0, Arena.west.getAbsoluteRadians(), 8.0));
        this.waypoints.addLast(new VehicleImpl(Arena.getMinX() + 20.0, Arena.getMinY() + 100.0, Arena.north.getAbsoluteRadians(), 8.0));
        this.waypoints.addLast(new VehicleImpl(Arena.getMinX() + 20.0, Arena.getMaxY() - 100.0, Arena.north.getAbsoluteRadians(), 8.0));
    }

    @Override
    public Vehicle getDestination() {
        Vehicle combatant = this.getCombatantSnapshot();
        Vehicle destination = this.waypoints.get(this.index);
        if (combatant.getPosition().getDistance(destination).distance() < 20.0) {
            this.index = (this.index + 1) % this.waypoints.size();
            destination = this.waypoints.get(this.index);
        }
        return destination;
    }

    @Override
    public void activate() {
        Vehicle combatant = this.getCombatantSnapshot();
        double minimumDistanceToCombatant = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < this.waypoints.size()) {
            double distance = combatant.getPosition().getDistance(this.waypoints.get(i)).distance();
            if (distance < minimumDistanceToCombatant) {
                this.index = i;
                minimumDistanceToCombatant = distance;
            }
            ++i;
        }
    }

    public static MovementMethod getInstance() {
        return singleton;
    }
}

