/*
 * Decompiled with CFR 0.152.
 */
package lunchie;

import java.awt.Color;
import lunchie.Log;
import lunchie.MatchInfo;
import lunchie.Position;
import lunchie.RobotEvent;
import lunchie.RobotInfo;
import robocode.AdvancedRobot;
import robocode.DeathEvent;
import robocode.HitWallEvent;
import robocode.Robot;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public class Lunchbox
extends AdvancedRobot {
    private static final String className = "Lunchbox";
    double distance;
    double deviation;
    double clearance;
    double accelleration;
    double aimTolerance = 0.5;
    double botSize;
    RobotInfo target = null;
    Position centreField = null;
    MatchInfo info = null;

    private final void setParameters() {
        Log.init(0, this);
        this.botSize = Math.max(this.getHeight(), this.getWidth());
        this.distance = 90.0;
        this.deviation = 32.0;
        this.clearance = 70.0;
        this.accelleration = 100.0;
        this.centreField = new Position(Position.ArenaWidth / 2.0, Position.ArenaHeight / 2.0, 20);
    }

    public void run() {
        Position.initialise(this);
        this.setParameters();
        this.info = new MatchInfo(this);
        this.setAdjustGunForRobotTurn(true);
        this.setMaxTurnRate(2.8444444444444446);
        this.setColors(Color.green, Color.blue, Color.red);
        while (true) {
            this.Move();
            this.Scan();
            this.Fire();
        }
    }

    public void Move() {
        if (this.getDistanceRemaining() == 0.0) {
            this.distance *= -1.0;
            double distThisTime = this.distance + this.distance * Math.random();
            this.setAhead(distThisTime);
            double devThisTime = this.deviation + this.deviation * Math.random();
            this.setTurn(devThisTime);
            this.setMaxTurnRate(devThisTime / Math.abs(distThisTime / 8.0));
        }
        this.checkWalls();
    }

    public void Scan() {
        this.setTurnRadarRight(-360.0);
    }

    public void Fire() {
        this.target = this.info.getTarget(this.target);
        if (this.target != null) {
            Position here = new Position();
            RobotEvent targEv = this.target.lastEvent();
            targEv.updateRange(here);
            double firePower = Math.min(2.0, this.getEnergy() / 15.0);
            Position targetPos = this.target.predict(firePower, here, this.getTime());
            if (targetPos != null && targetPos.isInArena()) {
                Log.print(2, className, "Fire", "Firing Soln: " + targetPos);
                if (this.pointGunAt(targetPos, here.getRangeTo(targetPos)) && this.getGunHeat() == 0.0 && this.getEnergy() > 1.0) {
                    this.fire(firePower);
                    return;
                }
            }
        } else if (this.getOthers() == 0) {
            this.doWinThing();
        }
        this.execute();
    }

    private final void doWinThing() {
        this.setHeading(0.0);
        this.distance = 40.0;
        this.deviation = 0.0;
    }

    public double calcHeadingTo(Position target) {
        Position rebased = new Position(target.getX() - this.getX(), target.getY() - this.getY(), 20);
        return rebased.getYTheta();
    }

    private final boolean pointGunAt(Position target, double range) {
        double aimToleranceR = Math.atan2(this.botSize, range) / 3.0;
        double turnAngle = this.calcHeadingTo(target) - this.getGunHeading();
        turnAngle = RobotInfo.normaliseAngle(turnAngle);
        this.setTurnGunRight(turnAngle);
        return Math.abs(turnAngle) < Math.toDegrees(aimToleranceR);
    }

    private final void checkWalls() {
        double travelDirection = this.getHeading();
        if (this.getDistanceRemaining() < 0.0) {
            travelDirection = RobotInfo.normaliseHeading(180.0 + travelDirection);
        }
        if (this.getX() <= this.clearance) {
            if (travelDirection > 180.0) {
                this.headTo(this.centreField);
            }
        } else if (this.getX() >= this.getBattleFieldWidth() - this.clearance) {
            if (travelDirection < 180.0) {
                this.headTo(this.centreField);
            }
        } else if (this.getY() <= this.clearance) {
            if (travelDirection > 90.0 && travelDirection < 270.0) {
                this.headTo(this.centreField);
            }
        } else if (this.getY() >= this.getBattleFieldHeight() - this.clearance && (travelDirection < 90.0 || travelDirection > 270.0)) {
            this.headTo(this.centreField);
        }
    }

    void setTurn(double angle) {
        if ((angle = RobotInfo.normaliseAngle(angle)) > 90.0) {
            this.setAhead(this.getDistanceRemaining() * -1.0);
            this.setTurnRight(angle - 180.0);
        } else if (angle < -90.0) {
            this.setAhead(this.getDistanceRemaining() * -1.0);
            this.setTurnRight(180.0 + angle);
        } else {
            this.setTurnRight(angle);
        }
    }

    double setHeading(double reqHeading) {
        double turnAngle = RobotInfo.normaliseAngle(reqHeading - this.getHeading());
        this.setTurn(turnAngle);
        return turnAngle;
    }

    void headTo(Position destination) {
        double rev = this.calcHeadingTo(destination);
        this.setHeading(rev);
    }

    public void onHitWall(HitWallEvent e) {
        this.clearance += 5.0;
        this.checkWalls();
    }

    public void onDeath(DeathEvent e) {
    }

    public void onWin(WinEvent e) {
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        ((Robot)this).out.println("Skipped Turn: " + e.getTime());
    }
}

