/*
 * Decompiled with CFR 0.152.
 */
package amarok;

import amarok.AbstractStrategy;
import amarok.Arena;
import amarok.BotConstants;
import amarok.BotMath;
import amarok.Enemy;
import amarok.FireSolution;
import amarok.Strategy;
import robocode.AdvancedRobot;

public class SittingDuckPrediction
extends AbstractStrategy
implements Strategy,
BotConstants {
    public double getGoodness() {
        Enemy nme = this.arena.getEnemy();
        AdvancedRobot me = this.arena.getMe();
        if (nme != null && (nme.getDeltaHeading() == 0.0 && nme.getVelocity() == 0.0 && nme.getDeltaVelocity() == 0.0 || BotMath.getDistance(me.getX(), me.getY(), nme.getPoint().x, nme.getPoint().y) < 100.0)) {
            return 1.0;
        }
        return 0.1;
    }

    public void doOneTurn() {
        Enemy nme = this.arena.getEnemy();
        if (nme == null) {
            return;
        }
        AdvancedRobot me = this.arena.getMe();
        FireSolution fireSolution = this.arena.getFireSolution();
        fireSolution.setCalculatedGunHeading(nme.getBearing());
        fireSolution.setCalculatedGunPower(3.0);
        double gunOffset = (me.getGunHeadingRadians() - fireSolution.getCalculatedGunHeading()) % (Math.PI * 2);
        int deltaGun = (int)(gunOffset / BotConstants.GUN_TURN_RATE);
        int deltaHeat = (int)(me.getGunHeat() / me.getGunCoolingRate());
        fireSolution.setCalculatedFiringTime((long)Math.max(deltaGun, deltaHeat) + me.getTime());
        fireSolution.setSolved(true);
    }

    public String toString() {
        return "SittingDuckPrediction";
    }

    public SittingDuckPrediction(Arena a) {
        super(a);
    }
}

