/*
 * Decompiled with CFR 0.152.
 */
package et;

import et.Location;
import java.util.Random;

public class EtMath {
    public static final Random randGen = new Random();
    private static Location _midPoint = new Location();

    public static final long sign(double d) {
        if (d >= 0.0) {
            return 1L;
        }
        return -1L;
    }

    public static final double rand(double d, double d2) {
        return randGen.nextDouble() * (d2 - d) + d;
    }

    public static final boolean randProb(double d) {
        return EtMath.rand(0.0, 100.0) >= 100.0 - d;
    }

    public static final double randGauss(double d, double d2) {
        double d3 = (d2 - d) * (randGen.nextGaussian() + 3.0) / 6.0 + d;
        if (d3 < d) {
            return d;
        }
        if (d3 > d2) {
            return d2;
        }
        return d3;
    }

    public static final String percent(double d) {
        if (d > 0.995) {
            return Math.round(d * 100.0) + "% ";
        }
        double d2 = (double)((long)(d * 1000.0)) / 10.0;
        return (d2 < 10.0 ? " " : "") + d2 + "%";
    }

    public static final double decimals(double d, int n) {
        double d2 = Math.pow(10.0, n);
        return (double)Math.round(d2 * d) / d2;
    }

    public static final double counterClockwiseAngle(double d) {
        return EtMath.normalAbsoluteAngle(450.0 - d);
    }

    public static final double normalRelativeAngle(double d) {
        double d2 = d % 360.0;
        if (d2 <= -180.0) {
            return 180.0 + d2 % 180.0;
        }
        if (d2 > 180.0) {
            return -180.0 + d2 % 180.0;
        }
        return d2;
    }

    public static final double normalAbsoluteAngle(double d) {
        if (d < 0.0) {
            return 360.0 + d % 360.0;
        }
        if (d >= 360.0) {
            return d % 360.0;
        }
        return d;
    }

    public static final Location midPoint(Location location, Location location2) {
        double d = location.getX() + location2.getX();
        double d2 = location.getY() + location2.getY();
        _midPoint.setLocation(d /= 2.0, d2 /= 2.0);
        return _midPoint;
    }
}

