/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import java.util.Vector;
import shrub.Bearing;
import shrub.Heading;
import shrub.Location;
import shrub.Radar;
import shrub.Sighting;

public class MultiTracker {
    private Radar mRadarRef = new Radar();
    private Heading mGunHdng = new Heading();
    private Location mTrackerLocn = new Location();
    private Vector mTargetList = new Vector();
    private int mCurrentTargetIndex = -1;
    private int mNumTargets = 0;
    private long mTimeNow = 0L;
    private long mNumTargetChanges = 0L;
    private boolean mChangeTargetAllowed = true;
    private boolean mPhasorResetOnTargetChange = false;
    private long mStalenessLimit = 20L;
    private double mEvalStaleCoeff = 5.0;
    private double mEvalSpeedCoeff = 5.0;
    private double mEvalAngleCoeff = 1.0;
    private double mEvalDistanceCoeff = 1.0;
    private double mEvalDisabledBonus = 100.0;

    public void Initialise() {
        Radar mRadarRef = new Radar();
        this.mGunHdng = new Heading();
        this.mTrackerLocn = new Location();
        this.mTargetList = new Vector();
        this.mCurrentTargetIndex = -1;
        this.mNumTargets = 0;
        this.mTimeNow = 0L;
        this.mNumTargetChanges = 0L;
        this.mChangeTargetAllowed = true;
        this.mPhasorResetOnTargetChange = false;
        this.mStalenessLimit = 20L;
        this.mEvalStaleCoeff = 5.0;
        this.mEvalSpeedCoeff = 5.0;
        this.mEvalAngleCoeff = 1.0;
        this.mEvalDistanceCoeff = 1.0;
        this.mEvalDisabledBonus = 100.0;
    }

    public void SetRadarRef(Radar radarRef) {
        this.mRadarRef = radarRef;
    }

    public void SetTrackerLocn(Location trackerLocn) {
        this.mTrackerLocn.Set(trackerLocn);
    }

    public void SetTrackerLocn(double xPos, double yPos) {
        this.mTrackerLocn.Set(xPos, yPos);
    }

    public void SetGunHdng(Heading gunHdng) {
        this.mGunHdng.Set(gunHdng);
    }

    public void SetGunHdng(double gunHdng) {
        this.mGunHdng.Set(gunHdng);
    }

    public void SetPhasorResetOnTargetChange(boolean newValue) {
        this.mPhasorResetOnTargetChange = newValue;
    }

    public void SetStalenessLimit(long newValue) {
        this.mStalenessLimit = newValue;
    }

    public void SetEvalStaleCoeff(double newValue) {
        this.mEvalStaleCoeff = newValue;
    }

    public void SetEvalAngleCoeff(double newValue) {
        this.mEvalAngleCoeff = newValue;
    }

    public void SetEvalSpeedCoeff(double newValue) {
        this.mEvalSpeedCoeff = newValue;
    }

    public void SetEvalDistanceCoeff(double newValue) {
        this.mEvalDistanceCoeff = newValue;
    }

    public void SetEvalDisabledBonus(double newValue) {
        this.mEvalDisabledBonus = newValue;
    }

    public long GetNumTargetChanges() {
        return this.mNumTargetChanges;
    }

    public void ReportSighting(Sighting newSighting) {
        int posn = -1;
        String targetName = newSighting.GetName();
        posn = this.FindNamedTarget(targetName);
        if (posn >= 0 && posn < this.mNumTargets) {
            Sighting oldSighting = (Sighting)this.mTargetList.get(posn);
            long newTimestamp = newSighting.GetTimestamp();
            long oldTimestamp = oldSighting.GetTimestamp();
            int newInaccuracy = newSighting.GetInaccuracy();
            int oldInaccuracy = oldSighting.GetInaccuracy();
            if (newTimestamp > oldTimestamp || newTimestamp == oldTimestamp && newInaccuracy <= oldInaccuracy) {
                this.UpdateTargetAt(posn, newSighting);
            } else {
                System.out.println("New sighting discarded, old is better");
                System.out.println("New sighting:");
                newSighting.Print();
                System.out.println("Old sighting:");
                oldSighting.Print();
            }
        } else {
            this.AddNewTarget(newSighting);
        }
    }

    private final int FindNamedTarget(String searchName) {
        int answer = -1;
        int index = 0;
        boolean found = false;
        while (!found && index < this.mNumTargets) {
            Sighting thisItem = (Sighting)this.mTargetList.get(index);
            String thisName = thisItem.GetName();
            if (thisName == searchName) {
                found = true;
                answer = index;
            }
            ++index;
        }
        return answer;
    }

    private final int FindClosestFreshTarget() {
        int thisIndex = 0;
        double closestDistanceSoFar = 999999.9;
        int closestIndexSoFar = -1;
        while (thisIndex < this.mNumTargets) {
            Sighting thisItem = (Sighting)this.mTargetList.get(thisIndex);
            long staleness = this.mTimeNow - thisItem.GetTimestamp();
            if (staleness < this.mStalenessLimit && staleness >= 0L) {
                Location thisLocn = thisItem.GetLocation();
                double thisDistance = thisLocn.DistanceTo(this.mTrackerLocn);
                if (thisDistance < closestDistanceSoFar) {
                    closestDistanceSoFar = thisDistance;
                    closestIndexSoFar = thisIndex;
                }
            } else if (staleness < 0L) {
                System.out.println("Tracker error!!! - target in future");
            }
            ++thisIndex;
        }
        return closestIndexSoFar;
    }

    public double ClosestTargetDistance() {
        int index = 0;
        double answer = 999999.0;
        if (this.mNumTargets > 0 && (index = this.FindClosestFreshTarget()) >= 0 && index < this.mNumTargets) {
            Sighting target = (Sighting)this.mTargetList.get(index);
            Location locn = target.GetLocation();
            answer = locn.DistanceTo(this.mTrackerLocn);
        }
        return answer;
    }

    private final void AddNewTarget(Sighting newSighting) {
        this.mTargetList.add(newSighting);
        this.mNumTargets = this.mTargetList.size();
    }

    private final void UpdateTargetAt(int index, Sighting newSighting) {
        this.mTargetList.set(index, newSighting);
    }

    private final void RemoveTargetAt(int index) {
        if (index == this.mCurrentTargetIndex) {
            this.mCurrentTargetIndex = -1;
        }
        this.mTargetList.remove(index);
        this.mNumTargets = this.mTargetList.size();
    }

    public void SetCurrentTarget(Sighting newSighting) {
        String name = newSighting.GetName();
        this.ReportSighting(newSighting);
        int index = this.FindNamedTarget(name);
        if (index >= 0 && index < this.mNumTargets) {
            this.mCurrentTargetIndex = index;
            ++this.mNumTargetChanges;
        } else {
            System.out.println("ERROR! Tracker::SetCurrentTarget, bad index " + index);
        }
    }

    public void SetCurrentTargetIndex(int index) {
        if (index >= 0 && index < this.mNumTargets) {
            this.mCurrentTargetIndex = index;
            ++this.mNumTargetChanges;
        } else {
            System.out.println("ERROR! Tracker::SetCurrentTargetIndex, bad index " + index);
        }
    }

    public void ClearCurrentTarget() {
        this.mCurrentTargetIndex = -1;
    }

    public void SetCurrentTime(long newTime) {
        this.mTimeNow = newTime;
    }

    public final int GetNumTargets() {
        return this.mNumTargets;
    }

    public final Sighting GetCurrentTarget() {
        Sighting targetRef = null;
        if (this.HasLockOn()) {
            targetRef = (Sighting)this.mTargetList.get(this.mCurrentTargetIndex);
        }
        return targetRef;
    }

    public final Sighting GetTargetByIndex(int index) {
        return (Sighting)this.mTargetList.get(index);
    }

    public final long LockOnStaleness() {
        long answer = 0L;
        if (this.HasLockOn()) {
            Sighting targetRef = this.GetCurrentTarget();
            long lockOnTimestamp = targetRef.GetTimestamp();
            answer = this.mTimeNow - lockOnTimestamp;
        } else {
            answer = 999999L;
        }
        return answer;
    }

    public final boolean HasLockOn() {
        boolean answer = false;
        if (this.mCurrentTargetIndex >= 0 && this.mCurrentTargetIndex < this.mNumTargets) {
            answer = true;
        }
        return answer;
    }

    public void ReportRobotDeath(String deathName) {
        int posn = this.FindNamedTarget(deathName);
        if (posn >= 0) {
            this.RemoveTargetAt(posn);
        } else {
            System.out.println("Unknown target, do nothing");
        }
    }

    public void ChooseCurrentTarget() {
        if (this.mChangeTargetAllowed) {
            int index = this.FindClosestFreshTarget();
            if (index != this.mCurrentTargetIndex && index >= 0 && index < this.mNumTargets) {
                this.SetCurrentTargetIndex(index);
                if (this.mPhasorResetOnTargetChange) {
                    this.mRadarRef.GetPhasor().SetTimeStarted(this.mTimeNow);
                }
            } else if (this.HasLockOn() && this.LockOnStaleness() > this.mStalenessLimit) {
                System.out.println();
                System.out.println("Clear stale lock on target " + index + ", at time " + this.mTimeNow);
                this.mCurrentTargetIndex = -1;
            }
        }
    }

    public void ChooseBestTarget() {
        if (this.mChangeTargetAllowed) {
            int index = this.EvaluateBestTarget();
            if (index != this.mCurrentTargetIndex && index >= 0 && index < this.mNumTargets) {
                this.SetCurrentTargetIndex(index);
                if (this.mPhasorResetOnTargetChange) {
                    this.mRadarRef.GetPhasor().SetTimeStarted(this.mTimeNow);
                }
            } else if (this.HasLockOn() && this.LockOnStaleness() > this.mStalenessLimit) {
                System.out.println();
                System.out.println("Clear stale lock on target " + index + ", at time " + this.mTimeNow);
                this.mCurrentTargetIndex = -1;
            }
        }
    }

    private final int EvaluateBestTarget() {
        int thisIndex = 0;
        double bestEvalSoFar = 999999.0;
        int bestIndexSoFar = -1;
        while (thisIndex < this.mNumTargets) {
            Sighting thisItem = (Sighting)this.mTargetList.get(thisIndex);
            long staleness = this.mTimeNow - thisItem.GetTimestamp();
            if (staleness < this.mStalenessLimit && staleness >= 0L) {
                double thisEval;
                Location thisTargetLocn = thisItem.GetLocation();
                double thisTargetDist = thisTargetLocn.DistanceTo(this.mTrackerLocn);
                double thisTargetEnergy = thisItem.GetEnergy();
                double thisTargetSpeed = Math.abs(thisItem.GetVelocity());
                Heading thisTargetHdng = new Heading();
                thisTargetHdng.SetFromTo(this.mTrackerLocn, thisTargetLocn);
                Bearing angleOffGun = new Bearing();
                angleOffGun.SetFromTo(this.mGunHdng, thisTargetHdng);
                double energyFactor = 0.0;
                if (thisTargetEnergy < 0.5) {
                    energyFactor = this.mEvalDisabledBonus;
                }
                if ((thisEval = this.mEvalDistanceCoeff * thisTargetDist + this.mEvalAngleCoeff * angleOffGun.GetAbs() + this.mEvalSpeedCoeff * thisTargetSpeed + this.mEvalStaleCoeff * (double)staleness - energyFactor) < bestEvalSoFar) {
                    bestEvalSoFar = thisEval;
                    bestIndexSoFar = thisIndex;
                }
            } else if (staleness < 0L) {
                System.out.println("Tracker error!!! - target in future");
            }
            ++thisIndex;
        }
        return bestIndexSoFar;
    }

    public void Print() {
        String lockedOnName = "{none}";
        System.out.println("===== Tracker2 =====");
        System.out.println("timeNow: " + this.mTimeNow);
        System.out.println("numTargets: " + this.mNumTargets);
        if (this.HasLockOn()) {
            lockedOnName = this.GetCurrentTarget().GetName();
        }
        System.out.println("lockedOn: [" + lockedOnName + "]");
    }

    public MultiTracker() {
        this.Initialise();
    }
}

