/*
 * Decompiled with CFR 0.152.
 */
package ghent.common;

import java.awt.geom.Point2D;
import robocode.util.Utils;

public class Target {
    private double energy;
    private double heading;
    private double oldHeading;
    private String name;
    private double velocity;
    private double x;
    private double y;

    public void setLocation(double bearing, double distance, double xrobot, double yrobot) {
        this.setLocation(xrobot + distance * Math.sin(Math.toRadians(bearing)), yrobot + distance * Math.cos(Math.toRadians(bearing)));
    }

    public void setLocation(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void setLocation(Point2D point) {
        this.setLocation(point.getX(), point.getY());
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public Point2D getLocation() {
        return new Point2D.Double(this.x, this.y);
    }

    public double getBearing(Point2D location) {
        double dx = this.x - location.getX();
        double dy = this.y - location.getY();
        return Math.toDegrees(Utils.normalAbsoluteAngle((double)Math.atan2(dx, dy)));
    }

    public double getDistance(Point2D point) {
        return this.getLocation().distance(point);
    }

    public double getDistance(double x, double y) {
        return this.getLocation().distance(x, y);
    }

    public double getEnergy() {
        return this.energy;
    }

    public void setEnergy(double energy) {
        this.energy = energy;
    }

    public double getHeading() {
        return this.heading;
    }

    public void setHeading(double angle, long time) {
        this.oldHeading = this.heading;
        this.heading = angle;
    }

    public double getOldHeading() {
        return this.oldHeading;
    }

    public double getHeadingChange() {
        return this.heading - this.oldHeading;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public void setVelocity(double velocity) {
        this.velocity = velocity;
    }

    public String toString() {
        return this.name + '{' + ", energy=" + this.energy + ", heading=" + this.heading + ", velocity=" + this.velocity + '}';
    }

    public void addEnergy(double bulletHitBonus) {
        this.energy += bulletHitBonus;
    }
}

